package ru.yandex.autotests.directapi.model.api5.adimages;

import java.util.Arrays;

import com.yandex.direct.api.v5.adimages.AdImageFieldEnum;
import com.yandex.direct.api.v5.adimages.GetRequest;

import ru.yandex.autotests.directapi.model.api5.general.GetRequestGeneralMap;

/**
 * Created by ginger on 06.02.16.
 */
public class GetRequestMap extends GetRequestGeneralMap<GetRequestMap> {
    public static final String GET_REQUEST = "GetRequest";
    public static final String SELECTION_CRITERIA = "selectionCriteria";
    public static final String FIELD_NAMES = "fieldNames";

    public static final Integer MAX_AMOUNT_OF_IMAGE_HASH_IN_GET_REQUEST = 10000;

    public GetRequestMap() {
        super();
        setBean(new GetRequest());
    }

    public GetRequestMap(GetRequest getRequest) {
        super();
        setBean(getRequest);
    }

    public GetRequestMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public GetRequestMap withSelectionCriteria(AdImageSelectionCriteriaMap selectionCriteria) {
        this.put(SELECTION_CRITERIA,
                (selectionCriteria == null) ? null : selectionCriteria.getBean());
        return this;
    }

    public GetRequestMap withFieldNames(AdImageFieldEnum... fieldNames) {
        this.put(FIELD_NAMES, Arrays.asList(fieldNames));
        return this;
    }

    public GetRequestMap withFieldNames(String... fieldNames) {
        this.put(FIELD_NAMES, Arrays.asList(fieldNames));
        return this;
    }

    public GetRequestMap withAllFieldNames() {
        this.put(FIELD_NAMES, Arrays.asList(
                AdImageFieldEnum.AD_IMAGE_HASH,
                AdImageFieldEnum.ASSOCIATED,
                AdImageFieldEnum.NAME,
                AdImageFieldEnum.ORIGINAL_URL,
                AdImageFieldEnum.PREVIEW_URL,
                AdImageFieldEnum.TYPE,
                AdImageFieldEnum.SUBTYPE
        ));
        return this;
    }
}
