package ru.yandex.autotests.directapi.model.api5.ads;


import com.yandex.direct.api.v5.ads.AdAddItem;
import com.yandex.direct.api.v5.ads.CpcVideoAdBuilderAdAdd;
import com.yandex.direct.api.v5.ads.CpmBannerAdBuilderAdAdd;
import com.yandex.direct.api.v5.ads.CpmVideoAdBuilderAdAdd;
import com.yandex.direct.api.v5.ads.DynamicTextAdAdd;
import com.yandex.direct.api.v5.ads.MobileAppAdBuilderAdAdd;
import com.yandex.direct.api.v5.ads.MobileAppCpcVideoAdBuilderAdAdd;
import com.yandex.direct.api.v5.ads.MobileAppImageAdAdd;
import com.yandex.direct.api.v5.ads.TextAdAdd;
import com.yandex.direct.api.v5.ads.TextAdBuilderAdAdd;
import com.yandex.direct.api.v5.ads.TextImageAdAdd;

import ru.yandex.autotests.directapi.enums.AdGroupType;
import ru.yandex.autotests.directapi.enums.BannerType;

/**
 * Created by pavryabov on 23.03.15.
 */
public class AdAddItemMap extends AdAddBaseMap<AdAddItemMap> {

    public static final String TEXT_AD = "textAd";
    public static final String DYNAMIC_TEXT_AD = "dynamicTextAd";
    public static final String MOBILE_APP_AD = "mobileAppAd";
    public static final String TEXT_IMAGE_AD = "textImageAd";
    public static final String TEXT_AD_BUILDER_AD = "textAdBuilderAd";
    public static final String MOBILE_APP_IMAGE_AD = "mobileAppImageAd";
    public static final String MOBILE_APP_CPC_VIDEO_AD_BUILDER_AD = "mobileAppCpcVideoAdBuilderAd";
    public static final String MOBILE_APP_AD_BUILDER_AD = "mobileAppAdBuilderAd";
    public static final String CPC_VIDEO_AD_BUILDER_AD = "cpcVideoAdBuilderAd";
    public static final String CPM_BANNER_AD_BUILDER_AD = "cpmBannerAdBuilderAd";
    public static final String CPM_VIDEO_AD_BUILDER_AD = "cpmVideoAdBuilderAd";

    public AdAddItemMap() {
        super();
        setBean(new AdAddItem());
    }

    public AdAddItemMap(AdAddItem adAddItem) {
        super();
        setBean(adAddItem);
    }

    public AdAddItemMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public AdAddItemMap withTextAd(TextAdAddMap textAdAddMap) {
        TextAdAdd textAdAdd =
                ((textAdAddMap == null) ? null : (TextAdAdd) (textAdAddMap.getBean()));
        this.put(TEXT_AD, textAdAdd);
        return this;
    }

    public AdAddItemMap withTextImageAd(TextImageAdAddMap textImageAdAddMap) {
        TextImageAdAdd textImageAdAdd =
                ((textImageAdAddMap == null) ? null : (TextImageAdAdd) (textImageAdAddMap.getBean()));
        this.put(TEXT_IMAGE_AD, textImageAdAdd);
        return this;
    }

    public AdAddItemMap withTextAdBuilderAd(TextAdBuilderAdAddMap textAdBuilderAdAddMap) {
        TextAdBuilderAdAdd textAdBuilderAdAdd =
                ((textAdBuilderAdAddMap == null) ? null : (TextAdBuilderAdAdd) (textAdBuilderAdAddMap.getBean()));
        this.put(TEXT_AD_BUILDER_AD, textAdBuilderAdAdd);
        return this;
    }

    public AdAddItemMap withDynamicTextAd(DynamicTextAdAddMap dynamicTextAdAddMap) {
        DynamicTextAdAdd dynamicTextAdAdd =
                ((dynamicTextAdAddMap == null) ? null : (DynamicTextAdAdd) (dynamicTextAdAddMap.getBean()));
        this.put(DYNAMIC_TEXT_AD, dynamicTextAdAdd);
        return this;
    }

    public AdAddItemMap withMobileAppAd(MobileAppAdAddMap mobileAppAdAddMap) {
        this.put(MOBILE_APP_AD, mobileAppAdAddMap != null ? mobileAppAdAddMap.getBean() : null);
        return this;
    }

    public AdAddItemMap withMobileAppImageAd(MobileAppImageAdAddMap mobileAppImageAdAddMap) {
        MobileAppImageAdAdd mobileAppImageAdAdd =
                ((mobileAppImageAdAddMap == null) ? null : (MobileAppImageAdAdd) (mobileAppImageAdAddMap.getBean()));
        this.put(MOBILE_APP_IMAGE_AD, mobileAppImageAdAdd);
        return this;
    }

    public AdAddItemMap withMobileAppCpcVideoAdBuilderAd(
            MobileAppCpcVideoAdBuilderAdAddMap mobileAppCpcVideoAdBuilderAdAddMap) {
        MobileAppCpcVideoAdBuilderAdAdd mobileAppCpcVideoAdBuilderAdAdd =
                ((mobileAppCpcVideoAdBuilderAdAddMap == null)
                        ? null
                        : (MobileAppCpcVideoAdBuilderAdAdd) mobileAppCpcVideoAdBuilderAdAddMap.getBean());
        this.put(MOBILE_APP_CPC_VIDEO_AD_BUILDER_AD, mobileAppCpcVideoAdBuilderAdAdd);
        return this;
    }

    public AdAddItemMap withMobileAppAdBuilderAd(MobileAppAdBuilderAdAddMap mobileAppAdBuilderAdAddMap) {
        MobileAppAdBuilderAdAdd mobileAppAdBuilderAdAdd =
                ((mobileAppAdBuilderAdAddMap == null) ? null : (MobileAppAdBuilderAdAdd) (mobileAppAdBuilderAdAddMap.getBean()));
        this.put(MOBILE_APP_AD_BUILDER_AD, mobileAppAdBuilderAdAdd);
        return this;
    }

    public AdAddItemMap withCpcVideoAdBuilderAd(CpcVideoAdBuilderAdAddMap cpcVideoAdBuilderAdAddMap) {
        CpcVideoAdBuilderAdAdd cpcVideoAdBuilderAdAdd =
        ((cpcVideoAdBuilderAdAddMap == null) ? null : (CpcVideoAdBuilderAdAdd) cpcVideoAdBuilderAdAddMap.getBean());
        this.put(CPC_VIDEO_AD_BUILDER_AD, cpcVideoAdBuilderAdAdd);
        return this;
    }

    public AdAddItemMap withCpmBannerAdBuilderAd(CpmBannerAdBuilderAdAddMap cpmBannerAdBuilderAdAddMap) {
        CpmBannerAdBuilderAdAdd cpmBannerAdBuilderAdAdd =
                ((cpmBannerAdBuilderAdAddMap == null) ? null : (CpmBannerAdBuilderAdAdd) (cpmBannerAdBuilderAdAddMap.getBean()));
        this.put(CPM_BANNER_AD_BUILDER_AD, cpmBannerAdBuilderAdAdd);
        return this;
    }

    public AdAddItemMap withCpmVideoAdBuilderAd(CpmVideoAdBuilderAdAddMap cpmVideoAdBuilderAdAddMap) {
        CpmVideoAdBuilderAdAdd cpmVideoAdBuilderAdAdd =
                ((cpmVideoAdBuilderAdAddMap == null) ? null : (CpmVideoAdBuilderAdAdd) (cpmVideoAdBuilderAdAddMap.getBean()));
        this.put(CPM_VIDEO_AD_BUILDER_AD, cpmVideoAdBuilderAdAdd);
        return this;
    }

    public AdAddItemMap withDefaultAd(BannerType type) {
        switch (type) {
            case TEXT:
                this.put(TEXT_AD, new TextAdAddMap().defaultTextAd().getBean());
                break;
            case MOBILE_CONTENT:
                this.put(MOBILE_APP_AD, new MobileAppAdAddMap().defaultMobileAppAd().getBean());
                break;
            case DYNAMIC:
                this.put(DYNAMIC_TEXT_AD, new DynamicTextAdAddMap().defaultDynamicTextAd().getBean());
                break;
        }
        return this;
    }

    public AdAddItemMap withAdWithAdImageHash(AdGroupType adGroupType, BannerType type, String adImageHash) {
        switch (type) {
            case TEXT:
                this.put(TEXT_AD, new TextAdAddMap().defaultTextAd().withAdImageHash(adImageHash).getBean());
                break;
            case MOBILE_CONTENT:
                this.put(MOBILE_APP_AD,
                        new MobileAppAdAddMap().defaultMobileAppAd().withAdImageHash(adImageHash).getBean());
                break;
            case DYNAMIC:
                this.put(DYNAMIC_TEXT_AD,
                        new DynamicTextAdAddMap().defaultDynamicTextAd().withAdImageHash(adImageHash).getBean());
                break;
            case IMAGE_AD:
                switch (adGroupType) {
                    case BASE:
                        this.put(TEXT_IMAGE_AD, new TextImageAdAddMap().defaultTextImageAd(adImageHash).getBean());
                        break;
                    case MOBILE_CONTENT:
                        this.put(MOBILE_APP_IMAGE_AD,
                                new MobileAppImageAdAddMap().defaultMobileAppImageAd(adImageHash).getBean());
                        break;
                }
                break;
        }
        return this;
    }

    public AdAddItemMap withAdWithSitelinkSetId(BannerType type, Long sitelinkSetId) {
        switch (type) {
            case TEXT:
                this.put(TEXT_AD, new TextAdAddMap().defaultTextAd().withSitelinkSetId(sitelinkSetId).getBean());
                break;
            case DYNAMIC:
                this.put(DYNAMIC_TEXT_AD,
                        new DynamicTextAdAddMap().defaultDynamicTextAd().withSitelinkSetId(sitelinkSetId).getBean());
                break;
        }
        return this;
    }
}
