package ru.yandex.autotests.directapi.model.api5.ads;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

public class AdBuilderAdAddBaseMap<T> extends ModelBeanMap<AdBuilderAdAddBaseMap> {
    public static final String CREATIVE = "creative";

    public AdBuilderAdAddBaseMap() {
        super();
    }

    public T withCreative(AdBuilderAdAddItemMap creative) {
        this.put(CREATIVE, creative.getBean());
        return (T) this;
    }

    public T withCreative(Long creativeId) {
        this.put(CREATIVE, new AdBuilderAdAddItemMap().withCreativeId(creativeId).getBean());
        return (T) this;
    }
}
