package ru.yandex.autotests.directapi.model.api5.ads;

import com.yandex.direct.api.v5.ads.AdBuilderAdGetItem;
import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

public class AdBuilderAdGetItemMap extends ModelBeanMap<AdBuilderAdGetItemMap> {

    public static final String CREATIVE_ID = "creativeId";
    public static final String THUMBNAIL_URL = "thumbnailUrl";
    public static final String PREVIEW_URL = "previewUrl";
    public static final String DEFAULT_URL = "ya.ru";

    public AdBuilderAdGetItemMap() {
        super();
        setBean(new AdBuilderAdGetItem());
    }

    public AdBuilderAdGetItemMap(AdBuilderAdGetItem adBuilderAdGetItem) {
        super();
        setBean(adBuilderAdGetItem);
    }

    public AdBuilderAdGetItemMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public AdBuilderAdGetItemMap withCreativeId(Long creativeId) {
        this.put(CREATIVE_ID, creativeId);
        return this;
    }

    public AdBuilderAdGetItemMap withThumbnailUrl(String thumbnailUrl) {
        this.put(THUMBNAIL_URL, thumbnailUrl);
        return this;
    }

    public AdBuilderAdGetItemMap withPreviewUrl(String previewUrl) {
        this.put(PREVIEW_URL, previewUrl);
        return this;
    }
}
