package ru.yandex.autotests.directapi.model.api5.ads;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

public class AdBuilderAdUpdateBaseMap<T> extends ModelBeanMap<AdBuilderAdUpdateBaseMap> {
    public static final String CREATIVE = "creative";

    public AdBuilderAdUpdateBaseMap() {
        super();
    }

    public T withCreative(AdBuilderAdUpdateItemMap creative) {
        this.put(CREATIVE, creative.getBean());
        return (T) this;
    }

    public T withCreative(Long creativeId) {
        this.put(CREATIVE, new AdBuilderAdUpdateItemMap().withCreativeId(creativeId).getBean());
        return (T) this;
    }
}
