package ru.yandex.autotests.directapi.model.api5.ads;

import com.yandex.direct.api.v5.adextensiontypes.AdExtensionTypeEnum;
import com.yandex.direct.api.v5.ads.AdExtensionAdGetItem;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by pavryabov on 02.03.16.
 */
public class AdExtensionAdGetItemMap extends ModelBeanMap<AdExtensionAdGetItemMap> {

    public static final String AD_EXTENSION_ID = "adExtensionId";
    public static final String TYPE = "type";

    public AdExtensionAdGetItemMap() {
        super();
        setBean(new AdExtensionAdGetItem());
    }

    public AdExtensionAdGetItemMap(AdExtensionAdGetItem adExtensionAdGetItem) {
        super();
        setBean(adExtensionAdGetItem);
    }

    public AdExtensionAdGetItemMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public AdExtensionAdGetItemMap withAdExtensionId(Long id) {
        this.put(AD_EXTENSION_ID, id);
        return this;
    }

    public AdExtensionAdGetItemMap withType(AdExtensionTypeEnum type) {
        this.put(TYPE, type);
        return this;
    }
}
