package ru.yandex.autotests.directapi.model.api5.ads;

import javax.xml.bind.JAXBElement;

import com.yandex.direct.api.v5.ads.*;
import com.yandex.direct.api.v5.general.StateEnum;
import com.yandex.direct.api.v5.general.StatusEnum;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by pavryabov on 08.04.15.
 */
public class AdGetItemMap extends ModelBeanMap<AdGetItemMap> {

    public static final String ID = "id";
    public static final String CAMPAIGN_ID = "campaignId";
    public static final String ADGROUP_ID = "adGroupId";
    public static final String STATUS = "status";
    public static final String STATE = "state";
    public static final String STATUS_CLARIFICATION = "statusClarification";
    public static final String AD_CATEGORIES = "adCategories";
    public static final String AGE_LABEL = "ageLabel";
    public static final String TYPE = "type";
    public static final String SUBTYPE = "subtype";
    public static final String TEXT_AD = "textAd";
    public static final String DYNAMIC_TEXT_AD = "dynamicTextAd";
    public static final String MOBILE_APP_AD = "mobileAppAd";
    public static final String TEXT_IMAGE_AD = "textImageAd";
    public static final String TEXT_AD_BUILDER_AD = "textAdBuilderAd";
    public static final String MOBILE_APP_IMAGE_AD = "mobileAppImageAd";
    public static final String MOBILE_APP_CPC_VIDEO_AD_BUILDER_AD = "mobileAppCpcVideoAdBuilderAd";
    public static final String MOBILE_APP_AD_BUILDER_AD = "mobileAppAdBuilderAd";
    public static final String CPC_VIDEO_AD_BUILDER_AD = "cpcVideoAdBuilderAd";
    public static final String CPM_BANNER_AD_BUILDER_AD = "cpmBannerAdBuilderAd";

    public AdGetItemMap() {
        super();
        setBean(new AdGetItem());
    }

    public AdGetItemMap(AdGetItem adGetItem) {
        super();
        setBean(adGetItem);
    }

    public AdGetItemMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public AdGetItemMap withId(Long id) {
        this.put(ID, id);
        return this;
    }

    public AdGetItemMap withCampaignId(Long campaignId) {
        this.put(CAMPAIGN_ID, campaignId);
        return this;
    }

    public AdGetItemMap withCampaignId(Integer campaignId) {
        this.put(CAMPAIGN_ID, campaignId.longValue());
        return this;
    }

    public AdGetItemMap withAdGroupId(Long adGroupId) {
        this.put(ADGROUP_ID, adGroupId);
        return this;
    }

    public AdGetItemMap withStatus(StatusEnum status) {
        this.put(STATUS, status);
        return this;
    }

    public AdGetItemMap withState(StateEnum state) {
        this.put(STATE, state);
        return this;
    }

    public AdGetItemMap withStatusClarification(String statusClarification) {
        this.put(STATUS_CLARIFICATION, statusClarification);
        return this;
    }

    public AdGetItemMap withAdCategories(ArrayOfAdCategoryEnumMap arrayOfAdCategoryEnumMap) {
        ArrayOfAdCategoryEnum adCategories =
                (ArrayOfAdCategoryEnum) ((arrayOfAdCategoryEnumMap == null) ? null
                        : arrayOfAdCategoryEnumMap.getBean());
        JAXBElement<ArrayOfAdCategoryEnum> jaxbElement =
                new ObjectFactory().createAdGetItemAdCategories(adCategories);
        this.put(AD_CATEGORIES, jaxbElement);
        return this;
    }

    public AdGetItemMap withAdCategories(AdCategoryEnum... items) {
        return this.withAdCategories(new ArrayOfAdCategoryEnumMap().withItems(items));
    }

    public AdGetItemMap withAdCategories(AdCategoryEnum item) {
        return this.withAdCategories((item == null) ? null : new ArrayOfAdCategoryEnumMap().withItems(item));
    }

    public AdGetItemMap withAgeLabel(AgeLabelEnum ageLabel) {
        JAXBElement<AgeLabelEnum> jaxbElement =
                new ObjectFactory().createAdGetItemAgeLabel(ageLabel);
        this.put(AGE_LABEL, jaxbElement);
        return this;
    }

    public AdGetItemMap withType(AdTypeEnum type) {
        this.put(TYPE, type);
        return this;
    }

    public AdGetItemMap withSubtype(AdSubtypeEnum subtype) {
        this.put(SUBTYPE, subtype);
        return this;
    }

    public AdGetItemMap withTextAd(TextAdGetMap textAdGetMap) {
        TextAdGet textAdGet =
                ((textAdGetMap == null) ? null : (TextAdGet) (textAdGetMap.getBean()));
        this.put(TEXT_AD, textAdGet);
        return this;
    }

    public AdGetItemMap withTextImageAd(TextImageAdGetMap textImageAdGetMap) {
        TextImageAdGet textImageAdGet =
                ((textImageAdGetMap == null) ? null : (TextImageAdGet) (textImageAdGetMap.getBean()));
        this.put(TEXT_IMAGE_AD, textImageAdGet);
        return this;
    }

    public AdGetItemMap withTextAdBuilderAd(TextAdBuilderAdGetMap textAdBuilderAdGetMap) {
        TextAdBuilderAdGet textAdBuilderAdGet =
                ((textAdBuilderAdGetMap == null) ? null : (TextAdBuilderAdGet) (textAdBuilderAdGetMap.getBean()));
        this.put(TEXT_AD_BUILDER_AD, textAdBuilderAdGet);
        return this;
    }

    public AdGetItemMap withDynamicTextAd(DynamicTextAdGetMap dynamicTextAdGetMap) {
        DynamicTextAdGet dynamicTextAdGet =
                ((dynamicTextAdGetMap == null) ? null : (DynamicTextAdGet) (dynamicTextAdGetMap.getBean()));
        this.put(DYNAMIC_TEXT_AD, dynamicTextAdGet);
        return this;
    }

    public AdGetItemMap withMobileAppAd(MobileAppAdGetMap mobileAppAdMap) {
        this.put(MOBILE_APP_AD, mobileAppAdMap != null ? mobileAppAdMap.getBean() : null);
        return this;
    }

    public AdGetItemMap withMobileAppImageAd(MobileAppImageAdGetMap mobileAppImageAdMap) {
        this.put(MOBILE_APP_IMAGE_AD, mobileAppImageAdMap != null ? mobileAppImageAdMap.getBean() : null);
        return this;
    }

    public AdGetItemMap withMobileAppCpcVideoAdBuilderAd(
            MobileAppCpcVideoAdBuilderAdGetMap mobileAppCpcVideoAdBuilderAd) {
        MobileAppCpcVideoAdBuilderAdGet mobileAppCpcVideoAdBuilderAdGet =
                ((mobileAppCpcVideoAdBuilderAd == null)
                        ? null
                        : (MobileAppCpcVideoAdBuilderAdGet) (mobileAppCpcVideoAdBuilderAd.getBean()));
        this.put(MOBILE_APP_CPC_VIDEO_AD_BUILDER_AD, mobileAppCpcVideoAdBuilderAdGet);
        return this;
    }

    public AdGetItemMap withMobileAppAdBuilderAd(MobileAppAdBuilderAdGetMap mobileAppAdBuilderAd) {
        MobileAppAdBuilderAdGet mobileAppAdBuilderAdGet =
                ((mobileAppAdBuilderAd == null) ? null : (MobileAppAdBuilderAdGet) (mobileAppAdBuilderAd.getBean()));
        this.put(MOBILE_APP_AD_BUILDER_AD, mobileAppAdBuilderAdGet);
        return this;
    }

    public AdGetItemMap withCpcVideoAdBuilderAd(CpcVideoAdBuilderAdGetMap cpcVideoAdBuilderAd) {
        CpcVideoAdBuilderAdGet cpcVideoAdBuilderAdGet =
                ((cpcVideoAdBuilderAd == null) ? null : (CpcVideoAdBuilderAdGet) (cpcVideoAdBuilderAd.getBean()));
        this.put(CPC_VIDEO_AD_BUILDER_AD, cpcVideoAdBuilderAdGet);
        return this;
    }

    public AdGetItemMap withCpmBannerAdBuilderAd(CpmBannerAdBuilderAdGetMap cpmBannerAdBuilderAd) {
        CpmBannerAdBuilderAdGet cpmBannerAdBuilderAdGet =
                ((cpmBannerAdBuilderAd == null) ? null : (CpmBannerAdBuilderAdGet) (cpmBannerAdBuilderAd.getBean()));
        this.put(CPM_BANNER_AD_BUILDER_AD, cpmBannerAdBuilderAdGet);
        return this;
    }

}
