package ru.yandex.autotests.directapi.model.api5.ads;

import com.yandex.direct.api.v5.ads.*;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by pavryabov on 23.03.15.
 */
public class AdUpdateItemMap extends ModelBeanMap<AdUpdateItemMap> {

    public static final String ID = "id";
    public static final String TEXT_AD = "textAd";
    public static final String DYNAMIC_TEXT_AD = "dynamicTextAd";
    public static final String MOBILE_APP_AD = "mobileAppAd";
    public static final String TEXT_IMAGE_AD = "textImageAd";
    public static final String MOBILE_APP_IMAGE_AD = "mobileAppImageAd";
    public static final String MOBILE_APP_CPC_VIDEO_AD_BUILDER_AD = "mobileAppCpcVideoAdBuilderAd";
    public static final String TEXT_AD_BUILDER_AD = "textAdBuilderAd";
    public static final String MOBILE_APP_AD_BUILDER_AD = "mobileAppAdBuilderAd";
    public static final String CPC_VIDEO_AD_BUILDER_AD = "cpcVideoAdBuilderAd";
    public static final String CPM_BANNER_AD_BUILDER_AD = "cpmBannerAdBuilderAd";

    public static final int MAX_ADS_AMOUNT = 1000;

    public AdUpdateItemMap() {
        super();
        setBean(new AdUpdateItem());
    }

    public AdUpdateItemMap(AdUpdateItem adUpdateItem) {
        super();
        setBean(adUpdateItem);
    }

    public AdUpdateItemMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public AdUpdateItemMap withId(Long id) {
        this.put(ID, id);
        return this;
    }

    public AdUpdateItemMap withTextAd(TextAdUpdateMap textAdUpdateMap) {
        TextAdUpdate textAdUpdate =
                ((textAdUpdateMap == null) ? null : (TextAdUpdate) (textAdUpdateMap.getBean()));
        this.put(TEXT_AD, textAdUpdate);
        return this;
    }

    public AdUpdateItemMap withDynamicTextAd(DynamicTextAdUpdateMap dynamicTextAdUpdateMap) {
        DynamicTextAdUpdate dynamicTextAdUpdate =
                ((dynamicTextAdUpdateMap == null) ? null : (DynamicTextAdUpdate) (dynamicTextAdUpdateMap.getBean()));
        this.put(DYNAMIC_TEXT_AD, dynamicTextAdUpdate);
        return this;
    }

    public AdUpdateItemMap withMobileAppAd(MobileAppAdUpdateMap mobileAppAdUpdateMap) {
        MobileAppAdUpdate mobileAppAdUpdate =
                ((mobileAppAdUpdateMap == null) ? null : (MobileAppAdUpdate) (mobileAppAdUpdateMap.getBean()));
        this.put(MOBILE_APP_AD, mobileAppAdUpdate);
        return this;
    }

    public AdUpdateItemMap withTextImageAd(TextImageAdUpdateMap textImageAdUpdateMap) {
        TextImageAdUpdate textImageAdUpdate =
                ((textImageAdUpdateMap == null) ? null : (TextImageAdUpdate) (textImageAdUpdateMap.getBean()));
        this.put(TEXT_IMAGE_AD, textImageAdUpdate);
        return this;
    }

    public AdUpdateItemMap withMobileAppImageAd(MobileAppImageAdUpdateMap mobileAppImageAdUpdateMap) {
        MobileAppImageAdUpdate mobileAppImageAdUpdate =
                ((mobileAppImageAdUpdateMap == null) ? null
                        : (MobileAppImageAdUpdate) (mobileAppImageAdUpdateMap.getBean()));
        this.put(MOBILE_APP_IMAGE_AD, mobileAppImageAdUpdate);
        return this;
    }

    public AdUpdateItemMap withMobileAppCpcVideoAdBuilderAd(
            MobileAppCpcVideoAdBuilderAdUpdateMap mobileAppCpcVideoAdBuilderAd) {
        MobileAppCpcVideoAdBuilderAdUpdate mobileAppCpcVideoAdBuilderAdUpdate =
                ((mobileAppCpcVideoAdBuilderAd == null) ? null
                        : (MobileAppCpcVideoAdBuilderAdUpdate) (mobileAppCpcVideoAdBuilderAd.getBean()));
        this.put(MOBILE_APP_CPC_VIDEO_AD_BUILDER_AD, mobileAppCpcVideoAdBuilderAdUpdate);
        return this;
    }

    public AdUpdateItemMap withTextAdBuilderAd(TextAdBuilderAdUpdateMap textAdBuilderAd) {
        TextAdBuilderAdUpdate textAdBuilderAdUpdate =
                ((textAdBuilderAd == null) ? null : (TextAdBuilderAdUpdate) (textAdBuilderAd.getBean()));
        this.put(TEXT_AD_BUILDER_AD, textAdBuilderAdUpdate);
        return this;
    }

    public AdUpdateItemMap withMobileAppAdBuilderAd(MobileAppAdBuilderAdUpdateMap mobileAppAdBuilderAd) {
        MobileAppAdBuilderAdUpdate mobileAppAdBuilderAdUpdate =
                ((mobileAppAdBuilderAd == null) ? null
                        : (MobileAppAdBuilderAdUpdate) (mobileAppAdBuilderAd.getBean()));
        this.put(MOBILE_APP_AD_BUILDER_AD, mobileAppAdBuilderAdUpdate);
        return this;
    }

    public AdUpdateItemMap withCpcVideoAdBuilderAd(CpcVideoAdBuilderAdUpdateMap cpcVideoAdBuilderAd) {
        CpcVideoAdBuilderAdUpdate cpcVideoAdBuilderAdUpdate =
                ((cpcVideoAdBuilderAd == null) ? null
                        : (CpcVideoAdBuilderAdUpdate) (cpcVideoAdBuilderAd.getBean()));
        this.put(CPC_VIDEO_AD_BUILDER_AD, cpcVideoAdBuilderAdUpdate);
        return this;
    }

    public AdUpdateItemMap withCpmBannerAdBuilderAd(CpmBannerAdBuilderAdUpdateMap cpmBannerAdBuilderAd) {
        CpmBannerAdBuilderAdUpdate cpmBannerAdBuilderAdUpdate =
                ((cpmBannerAdBuilderAd == null) ? null
                        : (CpmBannerAdBuilderAdUpdate) (cpmBannerAdBuilderAd.getBean()));
        this.put(CPM_BANNER_AD_BUILDER_AD, cpmBannerAdBuilderAdUpdate);
        return this;
    }
}
