package ru.yandex.autotests.directapi.model.api5.ads;

import java.util.List;

import com.yandex.direct.api.v5.ads.AddRequest;

import ru.yandex.autotests.direct.utils.converter.BeanMapToBeanConverter;
import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

import static ch.lambdaj.Lambda.convert;

/**
 * Created by pavryabov on 23.03.15.
 */
public class AddRequestMap extends ModelBeanMap<AddRequestMap> {

    public static final String ADS = "ads";

    public static final int MAX_AMOUNT_OF_ADS_IN_REQUEST = 1000;
    public static final int MAX_AMOUNT_OF_ADS_IN_GROUP = 50;

    public AddRequestMap() {
        super();
        setBean(new AddRequest());
    }

    public AddRequestMap(AddRequest addRequest) {
        super();
        setBean(addRequest);
    }

    public AddRequestMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public AddRequestMap withAds(AdAddItemMap... ads) {
        this.put(ADS, (ads == null) ? null : convert(ads, new BeanMapToBeanConverter()));
        return this;
    }

    public AddRequestMap withAds(List<AdAddItemMap> ads) {
        this.put(ADS, (ads == null) ? null : convert(ads, new BeanMapToBeanConverter()));
        return this;
    }
}
