package ru.yandex.autotests.directapi.model.api5.ads;

import java.util.Arrays;

import com.yandex.direct.api.v5.ads.AdStateSelectionEnum;
import com.yandex.direct.api.v5.ads.AdStatusSelectionEnum;
import com.yandex.direct.api.v5.ads.AdTypeEnum;
import com.yandex.direct.api.v5.ads.AdsSelectionCriteria;
import com.yandex.direct.api.v5.general.ExtensionStatusSelectionEnum;
import com.yandex.direct.api.v5.general.YesNoEnum;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by pavryabov on 19.03.15.
 */
public class AdsSelectionCriteriaMap extends ModelBeanMap<AdsSelectionCriteriaMap> {

    public static final String IDS = "ids";
    public static final String STATES = "states";
    public static final String STATUSES = "statuses";
    public static final String CAMPAIGN_IDS = "campaignIds";
    public static final String ADGROUP_IDS = "adGroupIds";
    public static final String TYPES = "types";
    public static final String VCARD_IDS = "VCardIds";
    public static final String SITELINK_SET_IDS = "sitelinkSetIds";
    public static final String ADIMAGE_HASHES = "adImageHashes";
    public static final String VCARD_MODERATION_STATUSES = "VCardModerationStatuses";
    public static final String SITELINKS_MODERATION_STATUSES = "sitelinksModerationStatuses";
    public static final String ADIMAGE_MODERATION_STATUSES = "adImageModerationStatuses";
    public static final String MOBILE = "mobile";
    public static final String AD_EXTENSION_IDS = "adExtensionIds";

    public static final int IDS_MAX_LENGTH = 10000;
    public static final int CAMPAIGN_IDS_MAX_LENGTH = 10;
    public static final int ADGROUP_IDS_MAX_LENGTH = 1000;
    public static final int VCARD_IDS_MAX_LENGTH = 50;
    public static final int SITELINK_SET_IDS_MAX_LENGTH = 50;
    public static final int ADIMAGE_HASHES_MAX_LENGTH = 50;
    public static final int AD_EXTENSION_IDS_MAX_LENGTH = 50;

    public AdsSelectionCriteriaMap() {
        super();
        setBean(new AdsSelectionCriteria());
    }

    public AdsSelectionCriteriaMap(AdsSelectionCriteria adsSelectionCriteria) {
        super();
        setBean(adsSelectionCriteria);
    }

    public AdsSelectionCriteriaMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public AdsSelectionCriteriaMap withIds(Long... ids) {
        this.put(IDS, Arrays.asList(ids));
        return this;
    }

    public AdsSelectionCriteriaMap withStates(AdStateSelectionEnum... states) {
        this.put(STATES, Arrays.asList(states));
        return this;
    }

    public AdsSelectionCriteriaMap withStates(String... states) {
        this.put(STATES, Arrays.asList(states));
        return this;
    }

    public AdsSelectionCriteriaMap withStatuses(AdStatusSelectionEnum... statuses) {
        this.put(STATUSES, Arrays.asList(statuses));
        return this;
    }

    public AdsSelectionCriteriaMap withStatuses(String... statuses) {
        this.put(STATUSES, Arrays.asList(statuses));
        return this;
    }

    public AdsSelectionCriteriaMap withCampaignIds(Long... campaignIds) {
        this.put(CAMPAIGN_IDS, Arrays.asList(campaignIds));
        return this;
    }

    public AdsSelectionCriteriaMap withCampaignIds(Integer... campaignIds) {
        this.put(CAMPAIGN_IDS, Arrays.asList(campaignIds));
        return this;
    }

    public AdsSelectionCriteriaMap withAdGroupIds(Long... adGroupIds) {
        this.put(ADGROUP_IDS, Arrays.asList(adGroupIds));
        return this;
    }

    public AdsSelectionCriteriaMap withTypes(AdTypeEnum... types) {
        this.put(TYPES, Arrays.asList(types));
        return this;
    }

    public AdsSelectionCriteriaMap withTypes(String... types) {
        this.put(TYPES, Arrays.asList(types));
        return this;
    }

    public AdsSelectionCriteriaMap withVCardIds(Long... vCardIds) {
        this.put(VCARD_IDS, Arrays.asList(vCardIds));
        return this;
    }

    public AdsSelectionCriteriaMap withSitelinkSetIds(Long... sitelinkSetIds) {
        this.put(SITELINK_SET_IDS, Arrays.asList(sitelinkSetIds));
        return this;
    }

    public AdsSelectionCriteriaMap withAdImageHashes(String... adImageHashes) {
        this.put(ADIMAGE_HASHES, Arrays.asList(adImageHashes));
        return this;
    }

    public AdsSelectionCriteriaMap withVCardModerationStatuses(
            ExtensionStatusSelectionEnum... vCardModerationStatuses)
    {
        this.put(VCARD_MODERATION_STATUSES, Arrays.asList(vCardModerationStatuses));
        return this;
    }

    public AdsSelectionCriteriaMap withVCardModerationStatuses(String... vCardModerationStatuses) {
        this.put(VCARD_MODERATION_STATUSES, Arrays.asList(vCardModerationStatuses));
        return this;
    }

    public AdsSelectionCriteriaMap withSitelinksModerationStatuses(
            ExtensionStatusSelectionEnum... sitelinksModerationStatuses)
    {
        this.put(SITELINKS_MODERATION_STATUSES, Arrays.asList(sitelinksModerationStatuses));
        return this;
    }

    public AdsSelectionCriteriaMap withSitelinksModerationStatuses(String... sitelinksModerationStatuses) {
        this.put(SITELINKS_MODERATION_STATUSES, Arrays.asList(sitelinksModerationStatuses));
        return this;
    }

    public AdsSelectionCriteriaMap withAdImageModerationStatuses(
            ExtensionStatusSelectionEnum... adImageModerationStatuses)
    {
        this.put(ADIMAGE_MODERATION_STATUSES, Arrays.asList(adImageModerationStatuses));
        return this;
    }

    public AdsSelectionCriteriaMap withAdImageModerationStatuses(String... adImageModerationStatuses) {
        this.put(ADIMAGE_MODERATION_STATUSES, Arrays.asList(adImageModerationStatuses));
        return this;
    }

    public AdsSelectionCriteriaMap withMobile(YesNoEnum mobile) {
        this.put(MOBILE, mobile);
        return this;
    }

    public AdsSelectionCriteriaMap withAdExtensionIds(Long... adExtensionIds) {
        this.put(AD_EXTENSION_IDS, Arrays.asList(adExtensionIds));
        return this;
    }
}
