package ru.yandex.autotests.directapi.model.api5.ads;

import com.yandex.direct.api.v5.ads.ArchiveRequest;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;

/**
 * Created by pavryabov on 20.03.15.
 */
public class ArchiveRequestMap extends ModelBeanMap<ArchiveRequestMap> {

    public static final String SELECTION_CRITERIA = "selectionCriteria";

    public ArchiveRequestMap() {
        super();
        setBean(new ArchiveRequest());
    }

    public ArchiveRequestMap(ArchiveRequest archiveRequest) {
        super();
        setBean(archiveRequest);
    }

    public ArchiveRequestMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public ArchiveRequestMap withSelectionCriteria(IdsCriteriaMap selectionCriteria) {
        this.put(SELECTION_CRITERIA,
                (selectionCriteria == null) ? null : selectionCriteria.getBean());
        return this;
    }
}
