package ru.yandex.autotests.directapi.model.api5.ads;

import java.util.Arrays;

import com.yandex.direct.api.v5.ads.AdCategoryEnum;
import com.yandex.direct.api.v5.ads.ArrayOfAdCategoryEnum;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by pavryabov on 22.05.15.
 */
public class ArrayOfAdCategoryEnumMap extends ModelBeanMap<ArrayOfAdCategoryEnumMap> {

    public static final String ITEMS = "items";

    public ArrayOfAdCategoryEnumMap() {
        super();
        setBean(new ArrayOfAdCategoryEnum());
    }

    public ArrayOfAdCategoryEnumMap(ArrayOfAdCategoryEnum arrayOfAdCategoryEnum) {
        super();
        setBean(arrayOfAdCategoryEnum);
    }

    public ArrayOfAdCategoryEnumMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public ArrayOfAdCategoryEnumMap withItems(AdCategoryEnum... items) {
        this.put(ITEMS, Arrays.asList(items));
        return this;
    }
}
