package ru.yandex.autotests.directapi.model.api5.ads;

import com.yandex.direct.api.v5.ads.CpcVideoAdBuilderAdAdd;

public class CpcVideoAdBuilderAdAddMap extends AdBuilderAdAddBaseMap<CpcVideoAdBuilderAdAddMap> {
    public static final String HREF = "href";
    public static final String DEFAULT_HREF = "http://yandex.ru";

    public CpcVideoAdBuilderAdAddMap() {
        super();
        setBean(new CpcVideoAdBuilderAdAdd());
    }

    public CpcVideoAdBuilderAdAddMap withHref(String href) {
        this.put(HREF, href);
        return this;
    }

    public CpcVideoAdBuilderAdAddMap defaultCpcVideoAdBuilderAd(Long creativeId) {
        this.put(CREATIVE, new AdBuilderAdAddItemMap().withCreativeId(creativeId).getBean());
        this.put(HREF, DEFAULT_HREF);
        return this;
    }

    public CpcVideoAdBuilderAdAddMap defaultCpcVideoAdBuilderAd(AdBuilderAdAddItemMap creative) {
        this.put(CREATIVE, creative.getBean());
        this.put(HREF, DEFAULT_HREF);
        return this;
    }
}
