package ru.yandex.autotests.directapi.model.api5.ads;

import javax.xml.bind.JAXBElement;

import com.yandex.direct.api.v5.ads.CpcVideoAdBuilderAdUpdate;
import com.yandex.direct.api.v5.ads.ObjectFactory;

public class CpcVideoAdBuilderAdUpdateMap  extends AdBuilderAdUpdateBaseMap<CpcVideoAdBuilderAdUpdateMap> {
    public static final String HREF = "href";
    public static final String TURBO_PAGE_ID = "turboPageId";

    public CpcVideoAdBuilderAdUpdateMap() {
        super();
        setBean(new CpcVideoAdBuilderAdUpdate());
    }

    public CpcVideoAdBuilderAdUpdateMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public CpcVideoAdBuilderAdUpdateMap withHref(String href) {
        JAXBElement<String> jaxbElement = new ObjectFactory().createCpcVideoAdBuilderAdUpdateHref(href);
        this.put(HREF, jaxbElement);
        return this;
    }

    public CpcVideoAdBuilderAdUpdateMap withTurboPageId(Long turboPageId) {
        JAXBElement<Long> jaxbElement = new ObjectFactory()
                .createCpcVideoAdBuilderAdUpdateTurboPageId(turboPageId);
        this.put(TURBO_PAGE_ID, jaxbElement);
        return this;
    }







}

