package ru.yandex.autotests.directapi.model.api5.ads;

import java.util.List;

import com.yandex.direct.api.v5.ads.CpmBannerAdBuilderAdAdd;
import com.yandex.direct.api.v5.general.ArrayOfString;

import ru.yandex.autotests.directapi.model.api5.general.ArrayOfStringMap;

public class CpmBannerAdBuilderAdAddMap extends AdBuilderAdAddBaseMap<CpmBannerAdBuilderAdAddMap> {

    public static final String HREF = "href";
    public static final String TRACKING_PIXELS = "trackingPixels";

    public static final String DEFAULT_HREF = "http://ya.ru";

    public CpmBannerAdBuilderAdAddMap() {
        super();
        setBean(new CpmBannerAdBuilderAdAdd());
    }

    public CpmBannerAdBuilderAdAddMap(CpmBannerAdBuilderAdAdd cpmBannerAdBuilderAdAdd) {
        super();
        setBean(cpmBannerAdBuilderAdAdd);
    }

    public CpmBannerAdBuilderAdAddMap withHref(String href) {
        this.put(HREF, href);
        return this;
    }

    public CpmBannerAdBuilderAdAddMap withTrackingPixels(ArrayOfStringMap arrayOfStringMap) {
        ArrayOfString trackingPixels =
                ((arrayOfStringMap == null) ? null : (ArrayOfString) (arrayOfStringMap.getBean()));
        this.put(TRACKING_PIXELS, trackingPixels);
        return this;
    }

    public CpmBannerAdBuilderAdAddMap withTrackingPixels(String[] items) {
        return this.withTrackingPixels(new ArrayOfStringMap().withItems(items));
    }

    public CpmBannerAdBuilderAdAddMap withTrackingPixels(List<String> items) {
        return this.withTrackingPixels(new ArrayOfStringMap().withItems(items));
    }

    public CpmBannerAdBuilderAdAddMap defaultCpmBannerAdBuilderAd(AdBuilderAdAddItemMap creative) {
        this.put(CREATIVE, creative.getBean());
        this.put(HREF, DEFAULT_HREF);
        return this;
    }

    public CpmBannerAdBuilderAdAddMap defaultCpmBannerAdBuilderAd(Long creativeId) {
        this.put(CREATIVE, new AdBuilderAdAddItemMap().withCreativeId(creativeId).getBean());
        this.put(HREF, DEFAULT_HREF);
        return this;
    }
}
