package ru.yandex.autotests.directapi.model.api5.ads;

import javax.xml.bind.JAXBElement;

import com.yandex.direct.api.v5.ads.CpmBannerAdBuilderAdGet;
import com.yandex.direct.api.v5.ads.ObjectFactory;
import com.yandex.direct.api.v5.ads.TrackingPixelGetArray;
import com.yandex.direct.api.v5.general.ExtensionModeration;

import ru.yandex.autotests.directapi.model.api5.general.ExtensionModerationMap;

public class CpmBannerAdBuilderAdGetMap extends AdBuilderAdGetBaseMap<CpmBannerAdBuilderAdGetMap> {

    public static final String HREF = "href";
    public static final String TRACKING_PIXELS = "trackingPixels";
    public static final String TURBO_PAGE_ID = "turboPageId";
    public static final String TURBO_PAGE_MODERATION = "turboPageModeration";

    public CpmBannerAdBuilderAdGetMap() {
        super();
        setBean(new CpmBannerAdBuilderAdGet());
    }

    public CpmBannerAdBuilderAdGetMap(CpmBannerAdBuilderAdGet cpmBannerAdBuilderAdGet) {
        super();
        setBean(cpmBannerAdBuilderAdGet);
    }

    public CpmBannerAdBuilderAdGetMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public CpmBannerAdBuilderAdGetMap withHref(String href) {
        this.put(HREF, new ObjectFactory().createCpmBannerAdBuilderAdGetHref(href));
        return this;
    }

    public CpmBannerAdBuilderAdGetMap withTrackingPixels(TrackingPixelGetItemMap... pixels) {
        TrackingPixelGetArrayMap trackingPixelGetArrayMap =
                (pixels == null) ? null : new TrackingPixelGetArrayMap().withItems(pixels);
        return this.withTrackingPixels(trackingPixelGetArrayMap);
    }

    public CpmBannerAdBuilderAdGetMap withTrackingPixels(TrackingPixelGetArrayMap trackingPixelGetArrayMap) {
        TrackingPixelGetArray trackingPixels =
                (TrackingPixelGetArray) ((trackingPixelGetArrayMap == null) ? null : trackingPixelGetArrayMap.getBean());
        return this.put(TRACKING_PIXELS, new ObjectFactory().createCpmBannerAdBuilderAdGetTrackingPixels(trackingPixels));
    }

    public CpmBannerAdBuilderAdGetMap withTurboPageId(Long turboPageId) {
        this.put(TURBO_PAGE_ID, new ObjectFactory().createCpmBannerAdBuilderAdGetTurboPageId(turboPageId));
        return this;
    }

    public CpmBannerAdBuilderAdGetMap withTurboPageModeration(ExtensionModerationMap turboPageModeration) {
        JAXBElement<ExtensionModeration> jaxbElement =
                new ObjectFactory().createCpmBannerAdBuilderAdGetTurboPageModeration(
                        (turboPageModeration == null) ? null
                                : (ExtensionModeration) turboPageModeration.getBean());
        this.put(TURBO_PAGE_MODERATION, jaxbElement);
        return this;
    }
}
