package ru.yandex.autotests.directapi.model.api5.ads;

import java.util.List;

import javax.xml.bind.JAXBElement;

import com.yandex.direct.api.v5.ads.CpmBannerAdBuilderAdUpdate;
import com.yandex.direct.api.v5.ads.ObjectFactory;
import com.yandex.direct.api.v5.general.ArrayOfString;

import ru.yandex.autotests.directapi.model.api5.general.ArrayOfStringMap;

public class CpmBannerAdBuilderAdUpdateMap extends AdBuilderAdUpdateBaseMap<CpmBannerAdBuilderAdUpdateMap> {

    public static final String HREF = "href";
    public static final String TRACKING_PIXELS = "trackingPixels";
    public static final String TURBO_PAGE_ID = "turboPageId";


    public static final String DEFAULT_HREF = "http://ya.ru";

    public CpmBannerAdBuilderAdUpdateMap() {
        super();
        setBean(new CpmBannerAdBuilderAdUpdate());
    }

    public CpmBannerAdBuilderAdUpdateMap(CpmBannerAdBuilderAdUpdate cpmBannerAdBuilderAdUpdate) {
        super();
        setBean(cpmBannerAdBuilderAdUpdate);
    }

    public CpmBannerAdBuilderAdUpdateMap withHref(String href) {
        JAXBElement<String> jaxbElement = new ObjectFactory().createCpmBannerAdBuilderAdUpdateHref(href);
        this.put(HREF, jaxbElement);
        return this;
    }

    public CpmBannerAdBuilderAdUpdateMap withTurboPageId(Long turboPageId) {
        JAXBElement<Long> jaxbElement = new ObjectFactory().createCpmBannerAdBuilderAdUpdateTurboPageId(turboPageId);
        this.put(TURBO_PAGE_ID, jaxbElement);
        return this;
    }

    public CpmBannerAdBuilderAdUpdateMap withTrackingPixels(ArrayOfStringMap arrayOfStringMap) {
        ArrayOfString trackingPixels =
                ((arrayOfStringMap == null) ? null : (ArrayOfString) (arrayOfStringMap.getBean()));
        JAXBElement<ArrayOfString> jaxbElement =
                new ObjectFactory().createCpmBannerAdBuilderAdUpdateTrackingPixels(trackingPixels);
        this.put(TRACKING_PIXELS, jaxbElement);
        return this;
    }

    public CpmBannerAdBuilderAdUpdateMap withTrackingPixels(List<String> items) {
        return this.withTrackingPixels(new ArrayOfStringMap().withItems(items));
    }

    public CpmBannerAdBuilderAdUpdateMap defaultCpmBannerAdBuilderAd(AdBuilderAdUpdateItemMap creative) {
        this.put(CREATIVE, creative.getBean());
        this.put(HREF, DEFAULT_HREF);
        return this;
    }

    public CpmBannerAdBuilderAdUpdateMap defaultCpmBannerAdBuilderAd(Long creativeId) {
        this.put(CREATIVE, new AdBuilderAdUpdateItemMap().withCreativeId(creativeId).getBean());
        this.put(HREF, DEFAULT_HREF);
        return this;
    }
}
