package ru.yandex.autotests.directapi.model.api5.ads;

import java.util.List;

import com.yandex.direct.api.v5.ads.CpmVideoAdBuilderAdAdd;
import com.yandex.direct.api.v5.general.ArrayOfString;

import ru.yandex.autotests.directapi.model.api5.general.ArrayOfStringMap;

public class CpmVideoAdBuilderAdAddMap extends AdBuilderAdAddBaseMap<CpmVideoAdBuilderAdAddMap> {

    public static final String HREF = "href";
    public static final String TRACKING_PIXELS = "trackingPixels";

    public static final String DEFAULT_HREF = "http://ya.ru";

    public CpmVideoAdBuilderAdAddMap() {
        super();
        setBean(new CpmVideoAdBuilderAdAdd());
    }

    public CpmVideoAdBuilderAdAddMap(CpmVideoAdBuilderAdAdd cpmVideoAdBuilderAdAdd) {
        super();
        setBean(cpmVideoAdBuilderAdAdd);
    }

    public CpmVideoAdBuilderAdAddMap withHref(String href) {
        this.put(HREF, href);
        return this;
    }

    public CpmVideoAdBuilderAdAddMap withTrackingPixels(ArrayOfStringMap arrayOfStringMap) {
        ArrayOfString trackingPixels =
                ((arrayOfStringMap == null) ? null : (ArrayOfString) (arrayOfStringMap.getBean()));
        this.put(TRACKING_PIXELS, trackingPixels);
        return this;
    }

    public CpmVideoAdBuilderAdAddMap withTrackingPixels(String[] items) {
        return this.withTrackingPixels(new ArrayOfStringMap().withItems(items));
    }

    public CpmVideoAdBuilderAdAddMap withTrackingPixels(List<String> items) {
        return this.withTrackingPixels(new ArrayOfStringMap().withItems(items));
    }

    public CpmVideoAdBuilderAdAddMap defaultCpmVideoAdBuilderAd(AdBuilderAdAddItemMap creative) {
        this.put(CREATIVE, creative.getBean());
        this.put(HREF, DEFAULT_HREF);
        return this;
    }

    public CpmVideoAdBuilderAdAddMap defaultCpmVideoAdBuilderAd(Long creativeId) {
        this.put(CREATIVE, new AdBuilderAdAddItemMap().withCreativeId(creativeId).getBean());
        this.put(HREF, DEFAULT_HREF);
        return this;
    }
}
