package ru.yandex.autotests.directapi.model.api5.ads;

import com.yandex.direct.api.v5.ads.DynamicTextAdAdd;

/**
 * Created by pavryabov on 26.11.15.
 */
public class DynamicTextAdAddMap extends TextAdAddBaseMap<DynamicTextAdAddMap> {

    public static final String TEXT = "text";

    public static final String DEFAULT_TEXT = "text";

    public static final int MAX_TEXT_LENGTH = 81;
    public static final int MAX_WORD_IN_TEXT_LENGTH = 23;

    public static final int MAX_AD_EXTENSION_IDS_IN_AD = 50;

    public static final int MAX_NUMBER_OF_NARROW_CHARACTERS = 10;


    public DynamicTextAdAddMap() {
        super();
        setBean(new DynamicTextAdAdd());
    }

    public DynamicTextAdAddMap(DynamicTextAdAdd dynamicTextAdAdd) {
        super();
        setBean(dynamicTextAdAdd);
    }

    public DynamicTextAdAddMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public DynamicTextAdAddMap withText(String text) {
        this.put(TEXT, text);
        return this;
    }

    public DynamicTextAdAddMap defaultDynamicTextAd() {
        this.put(TEXT, DEFAULT_TEXT);
        return this;
    }
}
