package ru.yandex.autotests.directapi.model.api5.ads;

import com.yandex.direct.api.v5.ads.DynamicTextAdAdd;
import com.yandex.direct.api.v5.ads.DynamicTextAdUpdate;

/**
 * Created by pavryabov on 26.11.15.
 */
public class DynamicTextAdUpdateMap extends TextAdUpdateBaseMap<DynamicTextAdUpdateMap> {

    public static final String TEXT = "text";

    public static final int MAX_TEXT_LENGTH = 81;
    public static final int MAX_TEXT_WORD_LENGTH = 23;


    public DynamicTextAdUpdateMap() {
        super();
        setBean(new DynamicTextAdUpdate());
    }

    public DynamicTextAdUpdateMap(DynamicTextAdUpdate dynamicTextAdUpdate) {
        super();
        setBean(dynamicTextAdUpdate);
    }

    public DynamicTextAdUpdateMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public DynamicTextAdUpdateMap withText(String text) {
        this.put(TEXT, text);
        return this;
    }

    public DynamicTextAdUpdateMap defaultDynamicTextAd() {
        DynamicTextAdAdd dynamicTextAdAdd =
                (DynamicTextAdAdd) new DynamicTextAdAddMap().defaultDynamicTextAd().getBean();
        return this.withText(dynamicTextAdAdd.getText());
    }
}