package ru.yandex.autotests.directapi.model.api5.ads;

import java.util.Arrays;

import com.yandex.direct.api.v5.ads.AdFieldEnum;
import com.yandex.direct.api.v5.ads.CpcVideoAdBuilderAdFieldEnum;
import com.yandex.direct.api.v5.ads.CpmBannerAdBuilderAdFieldEnum;
import com.yandex.direct.api.v5.ads.DynamicTextAdFieldEnum;
import com.yandex.direct.api.v5.ads.GetRequest;
import com.yandex.direct.api.v5.ads.MobileAppAdBuilderAdFieldEnum;
import com.yandex.direct.api.v5.ads.MobileAppAdFieldEnum;
import com.yandex.direct.api.v5.ads.MobileAppCpcVideoAdBuilderAdFieldEnum;
import com.yandex.direct.api.v5.ads.MobileAppImageAdFieldEnum;
import com.yandex.direct.api.v5.ads.TextAdBuilderAdFieldEnum;
import com.yandex.direct.api.v5.ads.TextAdFieldEnum;
import com.yandex.direct.api.v5.ads.TextAdPriceExtensionFieldEnum;
import com.yandex.direct.api.v5.ads.TextImageAdFieldEnum;

import ru.yandex.autotests.directapi.model.api5.general.GetRequestGeneralMap;

/**
 * Created by pavryabov on 19.03.15.
 */
public class GetRequestMap extends GetRequestGeneralMap<GetRequestMap> {

    public static final String SELECTION_CRITERIA = "selectionCriteria";
    public static final String FIELD_NAMES = "fieldNames";
    public static final String TEXT_AD_FIELD_NAMES = "textAdFieldNames";
    public static final String TEXT_AD_PRICE_EXTENSION_FIELD_NAMES = "textAdPriceExtensionFieldNames";
    public static final String MOBILE_APP_AD_FIELD_NAMES = "mobileAppAdFieldNames";
    public static final String DYNAMIC_TEXT_AD_FIELD_NAMES = "dynamicTextAdFieldNames";
    public static final String TEXT_IMAGE_AD_FIELD_NAMES = "textImageAdFieldNames";
    public static final String TEXT_AD_BUILDER_AD_FIELD_NAMES = "textAdBuilderAdFieldNames";
    public static final String MOBILE_APP_IMAGE_AD_FIELD_NAMES = "mobileAppImageAdFieldNames";
    public static final String MOBILE_APP_CPC_VIDEO_AD_BUILDER_AD_FIELD_NAMES =
            "mobileAppCpcVideoAdBuilderAdFieldNames";
    public static final String MOBILE_APP_AD_BUILDER_AD_FIELD_NAMES = "mobileAppAdBuilderAdFieldNames";
    public static final String CPM_BANNER_AD_BUILDER_AD_FIELD_NAMES = "cpmBannerAdBuilderAdFieldNames";
    public static final String CPC_VIDEO_AD_BUILDER_AD_FIELD_NAMES = "cpcVideoAdBuilderAdFieldNames";

    public GetRequestMap() {
        super();
        setBean(new GetRequest());
    }

    public GetRequestMap(GetRequest getRequest) {
        super();
        setBean(getRequest);
    }

    public GetRequestMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public GetRequestMap withSelectionCriteria(AdsSelectionCriteriaMap selectionCriteria) {
        this.put(SELECTION_CRITERIA,
                (selectionCriteria == null) ? null : selectionCriteria.getBean());
        return this;
    }

    public GetRequestMap withFieldNames(AdFieldEnum... fieldNames) {
        this.put(FIELD_NAMES, Arrays.asList(fieldNames));
        return this;
    }

    public GetRequestMap withFieldNames(String... fieldNames) {
        this.put(FIELD_NAMES, Arrays.asList(fieldNames));
        return this;
    }

    public GetRequestMap withTextAdFieldNames(TextAdFieldEnum... textAdFieldNames) {
        this.put(TEXT_AD_FIELD_NAMES, Arrays.asList(textAdFieldNames));
        return this;
    }

    public GetRequestMap withTextAdFieldNames(String... textAdFieldNames) {
        this.put(TEXT_AD_FIELD_NAMES, Arrays.asList(textAdFieldNames));
        return this;
    }

    public GetRequestMap withTextAdPriceExtensionFieldNames(TextAdPriceExtensionFieldEnum... fieldNames) {
        this.put(TEXT_AD_PRICE_EXTENSION_FIELD_NAMES, Arrays.asList(fieldNames));
        return this;
    }

    public GetRequestMap withTextAdPriceExtensionFieldNames(String... fieldNames) {
        this.put(TEXT_AD_PRICE_EXTENSION_FIELD_NAMES, Arrays.asList(fieldNames));
        return this;
    }

    public GetRequestMap withMobileAppAdFieldNames(MobileAppAdFieldEnum... mobileAppAdFieldNames) {
        this.put(MOBILE_APP_AD_FIELD_NAMES, Arrays.asList(mobileAppAdFieldNames));
        return this;
    }

    public GetRequestMap withMobileAppAdFieldNames(String... mobileAppAdFieldNames) {
        this.put(MOBILE_APP_AD_FIELD_NAMES, Arrays.asList(mobileAppAdFieldNames));
        return this;
    }

    public GetRequestMap withTextImageAdFieldNames(TextImageAdFieldEnum... textImageAdFieldNames) {
        this.put(TEXT_IMAGE_AD_FIELD_NAMES, Arrays.asList(textImageAdFieldNames));
        return this;
    }

    public GetRequestMap withTextImageAdFieldNames(String... textImageAdFieldNames) {
        this.put(TEXT_IMAGE_AD_FIELD_NAMES, Arrays.asList(textImageAdFieldNames));
        return this;
    }

    public GetRequestMap withTextAdBuilderAdFieldNames(TextAdBuilderAdFieldEnum... textAdBuilderFieldNames) {
        this.put(TEXT_AD_BUILDER_AD_FIELD_NAMES, Arrays.asList(textAdBuilderFieldNames));
        return this;
    }


    public GetRequestMap withMobileAppImageAdFieldNames(MobileAppImageAdFieldEnum... mobileAppImageAdFieldNames) {
        this.put(MOBILE_APP_IMAGE_AD_FIELD_NAMES, Arrays.asList(mobileAppImageAdFieldNames));
        return this;
    }

    public GetRequestMap withMobileAppImageAdFieldNames(String... mobileAppImageAdFieldNames) {
        this.put(MOBILE_APP_IMAGE_AD_FIELD_NAMES, Arrays.asList(mobileAppImageAdFieldNames));
        return this;
    }

    public GetRequestMap withMobileAppCpcAdVideoAdBuilderAdFieldNames(
            MobileAppCpcVideoAdBuilderAdFieldEnum... mobileAppCpcAdVideoAdBuilderAdFieldNames) {
        this.put(MOBILE_APP_CPC_VIDEO_AD_BUILDER_AD_FIELD_NAMES,
                Arrays.asList(mobileAppCpcAdVideoAdBuilderAdFieldNames));
        return this;
    }

    public GetRequestMap withMobileAppAdBuilderAdFieldNames(
            MobileAppAdBuilderAdFieldEnum... mobileAppAdBuilderFieldNames)
    {
        this.put(MOBILE_APP_AD_BUILDER_AD_FIELD_NAMES, Arrays.asList(mobileAppAdBuilderFieldNames));
        return this;
    }

    public GetRequestMap withCpcAdVideoAdBuilderAdFieldNames(
            CpcVideoAdBuilderAdFieldEnum... cpcAdVideoAdBuilderAdFieldNames)
    {
        this.put(CPC_VIDEO_AD_BUILDER_AD_FIELD_NAMES, Arrays.asList(cpcAdVideoAdBuilderAdFieldNames));
        return this;
    }

    public GetRequestMap withDynamicTextAdFieldNames(DynamicTextAdFieldEnum... dynamicTextAdFieldNames) {
        this.put(DYNAMIC_TEXT_AD_FIELD_NAMES, Arrays.asList(dynamicTextAdFieldNames));
        return this;
    }

    public GetRequestMap withDynamicTextAdFieldNames(String... dynamicTextAdFieldNames) {
        this.put(DYNAMIC_TEXT_AD_FIELD_NAMES, Arrays.asList(dynamicTextAdFieldNames));
        return this;
    }

    public GetRequestMap withCpmBannerAdBuilderAdFieldNames(
            CpmBannerAdBuilderAdFieldEnum... cpmBannerAdBuilderAdFieldNames)
    {
        this.put(CPM_BANNER_AD_BUILDER_AD_FIELD_NAMES, Arrays.asList(cpmBannerAdBuilderAdFieldNames));
        return this;
    }
}
