package ru.yandex.autotests.directapi.model.api5.ads;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import com.yandex.direct.api.v5.ads.MobAppAgeLabelEnum;
import com.yandex.direct.api.v5.ads.MobileAppAdAdd;
import com.yandex.direct.api.v5.ads.MobileAppAdFeatureItem;
import com.yandex.direct.api.v5.general.MobileAppAdActionEnum;
import org.apache.commons.beanutils.BeanMap;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by semkagtn on 25.08.15.
 */
public class MobileAppAdAddMap extends ModelBeanMap<MobileAppAdAddMap> {

    public static final String AD_IMAGE_HASH = "adImageHash";
    public static final String TEXT = "text";
    public static final String TITLE = "title";
    public static final String TRACKING_URL = "trackingUrl";
    public static final String ACTION = "action";
    public static final String FEATURES = "features";
    public static final String AGE_LABEL = "ageLabel";

    public static final String DEFAULT_TEXT = "Default Text";
    public static final String DEFAULT_TITLE = "Default Title";
    public static final String DEFAULT_TRACKING_URL = "http://appmetrika.yandex.ru?{logid}";
    public static final MobileAppAdActionEnum DEFAULT_ACTION = MobileAppAdActionEnum.DOWNLOAD;
    public static final List<MobileAppAdFeatureItem> DEFAULT_FEATURES = Arrays.asList(
            (MobileAppAdFeatureItem) new MobileAppAdFeatureItemMap()
                    .defaultMobileAppAdFeature().getBean());

    public static final int MAX_TEXT_LENGTH = 81;
    public static final int MAX_TITLE_LENGTH = 35;
    public static final int MAX_WORD_IN_TEXT_LENGTH = 23;
    public static final int MAX_WORD_IN_TITLE_LENGTH = 22;

    public MobileAppAdAddMap() {
        super();
        setBean(new MobileAppAdAdd());
    }

    public MobileAppAdAddMap(MobileAppAdAdd mobileAppAdAdd) {
        super();
        setBean(mobileAppAdAdd);
    }

    public MobileAppAdAddMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public MobileAppAdAddMap withAdImageHash(String hash) {
        this.put(AD_IMAGE_HASH, hash);
        return this;
    }

    public MobileAppAdAddMap withText(String text) {
        this.put(TEXT, text);
        return this;
    }

    public MobileAppAdAddMap withTitle(String title) {
        this.put(TITLE, title);
        return this;
    }

    public MobileAppAdAddMap withTrackingUrl(String trackingUrl) {
        this.put(TRACKING_URL, trackingUrl);
        return this;
    }

    public MobileAppAdAddMap withAction(MobileAppAdActionEnum action) {
        this.put(ACTION, action);
        return this;
    }

    public MobileAppAdAddMap withFeatures(MobileAppAdFeatureItemMap... features) {
        this.put(FEATURES, features == null ? null
                : Stream.of(features)
                        .map(BeanMap::getBean)
                        .collect(Collectors.toList()));
        return this;
    }

    public MobileAppAdAddMap withAgeLabel(MobAppAgeLabelEnum ageLabel) {
        this.put(AGE_LABEL, ageLabel);
        return this;
    }

    public MobileAppAdAddMap defaultMobileAppAd() {
        this.put(TEXT, DEFAULT_TEXT);
        this.put(TITLE, DEFAULT_TITLE);
        this.put(ACTION, DEFAULT_ACTION);
        this.put(FEATURES, DEFAULT_FEATURES);
        this.put(TRACKING_URL, DEFAULT_TRACKING_URL);
        return this;
    }
}
