package ru.yandex.autotests.directapi.model.api5.ads;

import javax.xml.bind.JAXBElement;

import com.yandex.direct.api.v5.ads.MobileAppAdBase;
import com.yandex.direct.api.v5.ads.ObjectFactory;
import com.yandex.direct.api.v5.general.MobileAppAdActionEnum;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by semkagtn on 27.08.15.
 */
public class MobileAppAdBaseMap<T> extends ModelBeanMap<MobileAppAdBaseMap> {

    public static final String ACTION = "action";
    public static final String AD_IMAGE_HASH = "adImageHash";
    public static final String TEXT = "text";
    public static final String TITLE = "title";
    public static final String TRACKING_URL = "trackingUrl";

    public MobileAppAdBaseMap() {
        super();
        setBean(new MobileAppAdBase());
    }

    public T withText(String text) {
        this.put(TEXT, text);
        return (T) this;
    }

    public T withTitle(String title) {
        this.put(TITLE, title);
        return (T) this;
    }

    public T withAction(MobileAppAdActionEnum action) {
        this.put(ACTION, action);
        return (T) this;
    }

    public T withAdImageHash(String adImageHash) {
        JAXBElement<String> jaxbElement = new ObjectFactory().createMobileAppAdBaseAdImageHash(adImageHash);
        this.put(AD_IMAGE_HASH, jaxbElement);
        return (T) this;
    }

    public T withTrackingUrl(String trackingUrl) {
        JAXBElement<String> jaxbElement = new ObjectFactory().createMobileAppAdBaseTrackingUrl(trackingUrl);
        this.put(TRACKING_URL, jaxbElement);
        return (T) this;
    }
}
