package ru.yandex.autotests.directapi.model.api5.ads;

import com.yandex.direct.api.v5.ads.MobileAppAdBuilderAdAdd;

public class MobileAppAdBuilderAdAddMap extends AdBuilderAdAddBaseMap<MobileAppAdBuilderAdAddMap> {
    public static final String TRACKING_URL = "trackingUrl";
    public static final String DEFAULT_TRACKING_URL = "http://appmetrika.yandex.ru";

    public MobileAppAdBuilderAdAddMap() {
        super();
        setBean(new MobileAppAdBuilderAdAdd());
    }

    public MobileAppAdBuilderAdAddMap withTrackingUrl(String trackingUrl) {
        this.put(TRACKING_URL, trackingUrl);
        return this;
    }

    public MobileAppAdBuilderAdAddMap defaultMobileAppAdBuilderAd(Long creativeId) {
        this.put(CREATIVE, new AdBuilderAdAddItemMap().withCreativeId(creativeId).getBean());
        this.put(TRACKING_URL, DEFAULT_TRACKING_URL);
        return this;
    }

    public MobileAppAdBuilderAdAddMap defaultMobileAppAdBuilderAd(AdBuilderAdAddItemMap creative) {
        this.put(CREATIVE, creative.getBean());
        this.put(TRACKING_URL, DEFAULT_TRACKING_URL);
        return this;
    }

}
