package ru.yandex.autotests.directapi.model.api5.ads;

import com.yandex.direct.api.v5.ads.MobileAppAdBuilderAdGet;
import com.yandex.direct.api.v5.ads.ObjectFactory;

import javax.xml.bind.JAXBElement;

public class MobileAppAdBuilderAdGetMap extends AdBuilderAdGetBaseMap<MobileAppAdBuilderAdGetMap> {
    public static final String TRACKING_URL = "trackingUrl";

    public MobileAppAdBuilderAdGetMap() {
        super();
        setBean(new MobileAppAdBuilderAdGet());
    }

    public MobileAppAdBuilderAdGetMap(MobileAppAdBuilderAdGet mobileAppAdBuilderAdGet) {
        super();
        setBean(mobileAppAdBuilderAdGet);
    }

    public MobileAppAdBuilderAdGetMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public MobileAppAdBuilderAdGetMap withTrackingUrl(String trackingUrl) {
        JAXBElement<String> jaxbElement = new ObjectFactory().createMobileAppImageAdGetTrackingUrl(trackingUrl);
        this.put(TRACKING_URL, jaxbElement);
        return this;
    }

}