package ru.yandex.autotests.directapi.model.api5.ads;

import com.yandex.direct.api.v5.ads.MobileAppAdBuilderAdUpdate;
import com.yandex.direct.api.v5.ads.ObjectFactory;

import javax.xml.bind.JAXBElement;

public class MobileAppAdBuilderAdUpdateMap extends AdBuilderAdUpdateBaseMap<MobileAppAdBuilderAdUpdateMap> {
    public static final String TRACKING_URL = "trackingUrl";

    public MobileAppAdBuilderAdUpdateMap() {
        super();
        setBean(new MobileAppAdBuilderAdUpdate());
    }

    public MobileAppAdBuilderAdUpdateMap withTrackingUrl(String trackingUrl) {
        JAXBElement<String> jaxbElement = new ObjectFactory().createMobileAppImageAdGetTrackingUrl(trackingUrl);
        this.put(TRACKING_URL, jaxbElement);
        return this;
    }
}
