package ru.yandex.autotests.directapi.model.api5.ads;

import com.yandex.direct.api.v5.ads.MobileAppFeatureEnum;
import com.yandex.direct.api.v5.general.YesNoEnum;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by semkagtn on 31.08.15.
 */
public class MobileAppAdFeatureBaseItemMap<T> extends ModelBeanMap<MobileAppAdFeatureBaseItemMap> {

    public static final String FEATURE = "feature";
    public static final String ENABLED = "enabled";

    public static final MobileAppFeatureEnum DEFAULT_FEATURE = MobileAppFeatureEnum.ICON;
    public static final YesNoEnum DEFAULT_ENABLED = YesNoEnum.YES;

    public T withFeature(MobileAppFeatureEnum feature) {
        this.put(FEATURE, feature);
        return (T) this;
    }

    public T withFeature(String feature) {
        this.put(FEATURE, feature);
        return (T) this;
    }

    public T withEnabled(YesNoEnum enabled) {
        this.put(ENABLED, enabled);
        return (T) this;
    }

    public T withEnabled(String enabled) {
        this.put(ENABLED, enabled);
        return (T) this;
    }

    public T defaultMobileAppAdFeature() {
        this.put(FEATURE, DEFAULT_FEATURE);
        this.put(ENABLED, DEFAULT_ENABLED);
        return (T) this;
    }
}
