package ru.yandex.autotests.directapi.model.api5.ads;

import java.util.stream.Collectors;
import java.util.stream.Stream;

import javax.xml.bind.JAXBElement;

import com.yandex.direct.api.v5.adgroups.ObjectFactory;
import com.yandex.direct.api.v5.ads.MobileAppAdGet;
import com.yandex.direct.api.v5.general.ExtensionModeration;
import org.apache.commons.beanutils.BeanMap;

import ru.yandex.autotests.directapi.model.api5.general.ExtensionModerationMap;

/**
 * Created by semkagtn on 31.08.15.
 */
public class MobileAppAdGetMap extends MobileAppAdBaseMap<MobileAppAdGetMap> {

    public static final String AD_IMAGE_MODERATION = "adImageModeration";
    public static final String FEATURES = "features";

    public MobileAppAdGetMap() {
        super();
        setBean(new MobileAppAdGet());
    }

    public MobileAppAdGetMap(MobileAppAdGet mobileAppAdGet) {
        super();
        setBean(mobileAppAdGet);
    }

    public MobileAppAdGetMap withAdImageModeration(ExtensionModerationMap adImageModeration) {
        JAXBElement<ExtensionModeration> jaxbElement =
                new ObjectFactory().createMobileAppAdGroupGetAppIconModeration(
                        (adImageModeration == null) ? null : (ExtensionModeration) adImageModeration.getBean());
        this.put(AD_IMAGE_MODERATION, jaxbElement);
        return this;
    }

    public MobileAppAdGetMap withFeatures(MobileAppAdFeatureGetItemMap... features) {
        this.put(FEATURES, features == null ? null
                : Stream.of(features)
                        .map(BeanMap::getBean)
                        .collect(Collectors.toList()));
        return this;
    }
}
