package ru.yandex.autotests.directapi.model.api5.ads;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import com.yandex.direct.api.v5.ads.MobAppAgeLabelEnum;
import com.yandex.direct.api.v5.ads.MobileAppAdFeatureItem;
import com.yandex.direct.api.v5.ads.MobileAppAdUpdate;
import com.yandex.direct.api.v5.general.MobileAppAdActionEnum;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by semkagtn on 27.08.15.
 */
public class MobileAppAdUpdateMap extends MobileAppAdBaseMap<MobileAppAdUpdateMap> {

    public static final String FEATURES = "features";
    public static final String AGE_LABEL = "ageLabel";

    public static final List<MobileAppAdFeatureItem> DEFAULT_FEATURES = MobileAppAdAddMap.DEFAULT_FEATURES;
    public static final String DEFAULT_TEXT = MobileAppAdAddMap.DEFAULT_TEXT;
    public static final String DEFAULT_TITLE = MobileAppAdAddMap.DEFAULT_TITLE;
    public static final MobileAppAdActionEnum DEFAULT_ACTION = MobileAppAdAddMap.DEFAULT_ACTION;
    public static final String DEFAULT_TRACKING_URL = MobileAppAdAddMap.DEFAULT_TRACKING_URL;

    public MobileAppAdUpdateMap() {
        super();
        setBean(new MobileAppAdUpdate());
    }

    public MobileAppAdUpdateMap(MobileAppAdUpdate mobileAppAdUpdateMap) {
        super();
        setBean(mobileAppAdUpdateMap);
    }

    public MobileAppAdUpdateMap withFeatures(MobileAppAdFeatureItemMap... features) {
        this.put(FEATURES, features == null ? null
                : Stream.of(features).map(ModelBeanMap::getBean).collect(Collectors.toList()));
        return this;
    }

    public MobileAppAdUpdateMap withAgeLabel(MobAppAgeLabelEnum ageLabel) {
        this.put(AGE_LABEL, ageLabel);
        return this;
    }

    public MobileAppAdUpdateMap defaultMobileAppAd() {
        return this.withText(DEFAULT_TEXT)
                .withTitle(DEFAULT_TITLE)
                .withAction(DEFAULT_ACTION)
                .withTrackingUrl(DEFAULT_TRACKING_URL)
                .withFeatures(DEFAULT_FEATURES.stream()
                        .map(MobileAppAdFeatureItemMap::new)
                        .toArray(MobileAppAdFeatureItemMap[]::new));
    }
}
