package ru.yandex.autotests.directapi.model.api5.ads;

import com.yandex.direct.api.v5.ads.MobileAppCpcVideoAdBuilderAdAdd;

public class MobileAppCpcVideoAdBuilderAdAddMap extends AdBuilderAdAddBaseMap<MobileAppCpcVideoAdBuilderAdAddMap> {
    public static final String TRACKING_URL = "trackingUrl";
    public static final String DEFAULT_TRACKING_URL = "http://appmetrika.yandex.ru";

    public MobileAppCpcVideoAdBuilderAdAddMap() {
        super();
        setBean(new MobileAppCpcVideoAdBuilderAdAdd());
    }

    public MobileAppCpcVideoAdBuilderAdAddMap withTrackingUrl(String trackingUrl) {
        this.put(TRACKING_URL, trackingUrl);
        return this;
    }

    public MobileAppCpcVideoAdBuilderAdAddMap defaultMobileAppCpcVideoAdBuilderAd(Long creativeId) {
        this.put(CREATIVE, new AdBuilderAdAddItemMap().withCreativeId(creativeId).getBean());
        this.put(TRACKING_URL, DEFAULT_TRACKING_URL);
        return this;
    }

    public MobileAppCpcVideoAdBuilderAdAddMap defaultMobileAppCpcVideoAdBuilderAd(AdBuilderAdAddItemMap creative) {
        this.put(CREATIVE, creative.getBean());
        this.put(TRACKING_URL, DEFAULT_TRACKING_URL);
        return this;
    }
}
