package ru.yandex.autotests.directapi.model.api5.ads;

import com.yandex.direct.api.v5.ads.MobileAppImageAdAdd;

/**
 * Created by gerdler on 05.07.16.
 */
public class MobileAppImageAdAddMap extends ImageAdAddBaseMap<MobileAppImageAdAddMap> {
    public static final String TRACKING_URL = "trackingUrl";
    public static final String DEFAULT_TRACKING_URL = "http://appmetrika.yandex.ru";

    public MobileAppImageAdAddMap() {
        super();
        setBean(new MobileAppImageAdAdd());
    }

    public MobileAppImageAdAddMap withTrackingUrl(String trackingUrl) {
        this.put(TRACKING_URL, trackingUrl);
        return this;
    }

    public MobileAppImageAdAddMap defaultMobileAppImageAd(String adImageHash) {
        this.put(ADIMAGE_HASH, adImageHash);
        this.put(TRACKING_URL, DEFAULT_TRACKING_URL);
        return this;
    }

}
