package ru.yandex.autotests.directapi.model.api5.ads;

import javax.xml.bind.JAXBElement;

import com.yandex.direct.api.v5.ads.MobileAppImageAdGet;
import com.yandex.direct.api.v5.ads.ObjectFactory;

/**
 * Created by gerdler on 07.07.16.
 */
public class MobileAppImageAdGetMap extends ImageAdGetBaseMap<MobileAppImageAdGetMap> {
    public static final String TRACKING_URL = "trackingUrl";

    public MobileAppImageAdGetMap() {
        super();
        setBean(new MobileAppImageAdGet());
    }

    public MobileAppImageAdGetMap(MobileAppImageAdGet mobileAppImageAdGet) {
        super();
        setBean(mobileAppImageAdGet);
    }

    public MobileAppImageAdGetMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public MobileAppImageAdGetMap withTrackingUrl(String trackingUrl) {
        JAXBElement<String> jaxbElement = new ObjectFactory().createMobileAppImageAdGetTrackingUrl(trackingUrl);
        this.put(TRACKING_URL, jaxbElement);
        return this;
    }

}
