package ru.yandex.autotests.directapi.model.api5.ads;

import javax.xml.bind.JAXBElement;

import com.yandex.direct.api.v5.ads.MobileAppImageAdUpdate;
import com.yandex.direct.api.v5.ads.ObjectFactory;

/**
 * Created by gerdler on 12.07.16.
 */
public class MobileAppImageAdUpdateMap extends ImageAdUpdateBaseMap<MobileAppImageAdUpdateMap> {
    public static final String TRACKING_URL = "trackingUrl";

    public MobileAppImageAdUpdateMap() {
        super();
        setBean(new MobileAppImageAdUpdate());
    }

    public MobileAppImageAdUpdateMap(MobileAppImageAdUpdate mobileAppImageAdUpdate) {
        super();
        setBean(mobileAppImageAdUpdate);
    }

    public MobileAppImageAdUpdateMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public MobileAppImageAdUpdateMap withTrackingUrl(String trackingUrl) {
        JAXBElement<String> jaxbElement = new ObjectFactory().createMobileAppImageAdUpdateTrackingUrl(trackingUrl);
        this.put(TRACKING_URL, jaxbElement);
        return this;
    }
}
