package ru.yandex.autotests.directapi.model.api5.ads;

import com.yandex.direct.api.v5.ads.ModerateRequest;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;

/**
 * Created by pavryabov on 20.03.15.
 */
public class ModerateRequestMap extends ModelBeanMap<ModerateRequestMap> {

    public static final String SELECTION_CRITERIA = "selectionCriteria";

    public ModerateRequestMap() {
        super();
        setBean(new ModerateRequest());
    }

    public ModerateRequestMap(ModerateRequest moderateRequest) {
        super();
        setBean(moderateRequest);
    }

    public ModerateRequestMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public ModerateRequestMap withSelectionCriteria(IdsCriteriaMap selectionCriteria) {
        this.put(SELECTION_CRITERIA,
                (selectionCriteria == null) ? null : selectionCriteria.getBean());
        return this;
    }
}
