package ru.yandex.autotests.directapi.model.api5.ads;

import com.yandex.direct.api.v5.ads.PriceCurrencyEnum;
import com.yandex.direct.api.v5.ads.PriceExtensionAddItem;
import com.yandex.direct.api.v5.ads.PriceQualifierEnum;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

public class PriceExtensionAddItemMap extends ModelBeanMap<PriceExtensionAddItemMap> {
    public static final String PRICE = "price";
    public static final String OLD_PRICE = "oldPrice";
    public static final String PRICE_QUALIFIER = "priceQualifier";
    public static final String PRICE_CURRENCY = "priceCurrency";

    public PriceExtensionAddItemMap() {
        super();
        setBean(new PriceExtensionAddItem());
    }

    public PriceExtensionAddItemMap(PriceExtensionAddItem priceExtensionItem) {
        super();
        setBean(priceExtensionItem);
    }

    public PriceExtensionAddItemMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public PriceExtensionAddItemMap withPrice(Long price) {
        this.put(PRICE, price);
        return this;
    }

    public PriceExtensionAddItemMap withOldPrice(Long oldPrice) {
        this.put(OLD_PRICE, oldPrice);
        return this;
    }

    public PriceExtensionAddItemMap withPriceQualifier(PriceQualifierEnum priceQualifier) {
        this.put(PRICE_QUALIFIER, priceQualifier);
        return this;
    }

    public PriceExtensionAddItemMap withPriceCurrency(PriceCurrencyEnum priceCurrency) {
        this.put(PRICE_CURRENCY, priceCurrency);
        return this;
    }
}
