package ru.yandex.autotests.directapi.model.api5.ads;

import javax.xml.bind.JAXBElement;

import com.yandex.direct.api.v5.ads.ObjectFactory;
import com.yandex.direct.api.v5.ads.PriceCurrencyEnum;
import com.yandex.direct.api.v5.ads.PriceExtensionGetItem;
import com.yandex.direct.api.v5.ads.PriceQualifierEnum;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

public class PriceExtensionGetItemMap extends ModelBeanMap<PriceExtensionGetItemMap> {
    public static final String PRICE = "price";
    public static final String OLD_PRICE = "oldPrice";
    public static final String PRICE_QUALIFIER = "priceQualifier";
    public static final String PRICE_CURRENCY = "priceCurrency";

    public PriceExtensionGetItemMap() {
        super();
        setBean(new PriceExtensionGetItem());
    }

    public PriceExtensionGetItemMap(PriceExtensionGetItem priceExtensionItem) {
        super();
        setBean(priceExtensionItem);
    }

    public PriceExtensionGetItemMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public PriceExtensionGetItemMap withPrice(Long price) {
        this.put(PRICE, price);
        return this;
    }

    public PriceExtensionGetItemMap withOldPrice(Long oldPrice) {
        JAXBElement<Long> jaxbElement = new ObjectFactory().createPriceExtensionGetItemOldPrice(oldPrice);
        this.put(OLD_PRICE, jaxbElement);
        return this;
    }

    public PriceExtensionGetItemMap withPriceQualifier(PriceQualifierEnum priceQualifier) {
        this.put(PRICE_QUALIFIER, priceQualifier);
        return this;
    }

    public PriceExtensionGetItemMap withPriceCurrency(PriceCurrencyEnum priceCurrency) {
        this.put(PRICE_CURRENCY, priceCurrency);
        return this;
    }
}
