package ru.yandex.autotests.directapi.model.api5.ads;

import javax.xml.bind.JAXBElement;

import com.yandex.direct.api.v5.ads.ObjectFactory;
import com.yandex.direct.api.v5.ads.PriceCurrencyEnum;
import com.yandex.direct.api.v5.ads.PriceExtensionUpdateItem;
import com.yandex.direct.api.v5.ads.PriceQualifierEnum;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

public class PriceExtensionUpdateItemMap extends ModelBeanMap<PriceExtensionUpdateItemMap> {
    public static final String PRICE = "price";
    public static final String OLD_PRICE = "oldPrice";
    public static final String PRICE_QUALIFIER = "priceQualifier";
    public static final String PRICE_CURRENCY = "priceCurrency";

    public PriceExtensionUpdateItemMap() {
        super();
        setBean(new PriceExtensionUpdateItem());
    }

    public PriceExtensionUpdateItemMap(PriceExtensionUpdateItem priceExtensionItem) {
        super();
        setBean(priceExtensionItem);
    }

    public PriceExtensionUpdateItemMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public PriceExtensionUpdateItemMap withPrice(Long price) {

        this.put(PRICE, price);
        return this;
    }

    public PriceExtensionUpdateItemMap withOldPrice(Long oldPrice) {
        JAXBElement<Long> jaxbElement = new ObjectFactory().createPriceExtensionUpdateItemOldPrice(oldPrice);
        this.put(OLD_PRICE, jaxbElement);
        return this;
    }

    public PriceExtensionUpdateItemMap withPriceQualifier(PriceQualifierEnum priceQualifier) {
        this.put(PRICE_QUALIFIER, priceQualifier);
        return this;
    }

    public PriceExtensionUpdateItemMap withPriceCurrency(PriceCurrencyEnum priceCurrency) {
        this.put(PRICE_CURRENCY, priceCurrency);
        return this;
    }
}
