package ru.yandex.autotests.directapi.model.api5.ads;

import com.yandex.direct.api.v5.ads.ResumeRequest;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;

/**
 * Created by pavryabov on 19.03.15.
 */
public class ResumeRequestMap extends ModelBeanMap<ResumeRequestMap> {

    public static final String SELECTION_CRITERIA = "selectionCriteria";

    public ResumeRequestMap() {
        super();
        setBean(new ResumeRequest());
    }

    public ResumeRequestMap(ResumeRequest resumeRequest) {
        super();
        setBean(resumeRequest);
    }

    public ResumeRequestMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public ResumeRequestMap withSelectionCriteria(IdsCriteriaMap selectionCriteria) {
        this.put(SELECTION_CRITERIA,
                (selectionCriteria == null) ? null : selectionCriteria.getBean());
        return this;
    }
}
