package ru.yandex.autotests.directapi.model.api5.ads;

import com.yandex.direct.api.v5.ads.SuspendRequest;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;

/**
 * Created by pavryabov on 19.03.15.
 */
public class SuspendRequestMap extends ModelBeanMap<SuspendRequestMap> {

    public static final String SELECTION_CRITERIA = "selectionCriteria";

    public SuspendRequestMap() {
        super();
        setBean(new SuspendRequest());
    }

    public SuspendRequestMap(SuspendRequest suspendRequest) {
        super();
        setBean(suspendRequest);
    }

    public SuspendRequestMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public SuspendRequestMap withSelectionCriteria(IdsCriteriaMap selectionCriteria) {
        this.put(SELECTION_CRITERIA,
                (selectionCriteria == null) ? null : selectionCriteria.getBean());
        return this;
    }
}
