package ru.yandex.autotests.directapi.model.api5.ads;

import java.util.Arrays;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;


/**
 * Created by pavryabov on 23.03.15.
 */
public class TextAdAddBaseMap<T> extends ModelBeanMap<TextAdAddBaseMap> {

    public static final String VCARD_ID = "VCardId";
    public static final String ADIMAGE_HASH = "adImageHash";
    public static final String SITELINK_SET_ID = "sitelinkSetId";
    public static final String AD_EXTENSION_IDS = "adExtensionIds";

    public TextAdAddBaseMap() {
        super();
    }

    public T withVCardId(Long vCardId) {
        this.put(VCARD_ID, vCardId);
        return (T) this;
    }

    public T withAdImageHash(String adImageHash) {
        this.put(ADIMAGE_HASH, adImageHash);
        return (T) this;
    }

    public T withSitelinkSetId(Long sitelinkSetId) {
        this.put(SITELINK_SET_ID, sitelinkSetId);
        return (T) this;
    }

    public T withAdExtensionIds(Long... adExtensionIds) {
        this.put(AD_EXTENSION_IDS, Arrays.asList(adExtensionIds));
        return (T) this;
    }
}
