package ru.yandex.autotests.directapi.model.api5.ads;

import com.yandex.direct.api.v5.ads.PriceExtensionAddItem;
import com.yandex.direct.api.v5.ads.TextAdAdd;
import com.yandex.direct.api.v5.ads.VideoExtensionAddItem;
import com.yandex.direct.api.v5.general.YesNoEnum;


/**
 * Created by pavryabov on 23.03.15.
 */
public class TextAdAddMap extends TextAdAddBaseMap<TextAdAddMap> {

    public static final String TEXT = "text";
    public static final String TITLE = "title";
    public static final String TITLE_2 = "title2";
    public static final String HREF = "href";
    public static final String MOBILE = "mobile";
    public static final String TURBO_PAGE_ID = "turboPageId";
    public static final String DISPLAY_URL_PATH = "displayUrlPath";
    public static final String VIDEO_EXTENSION = "videoExtension";
    public static final String PRICE_EXTENSION = "priceExtension";
    public static final String BUSINESS_ID = "businessId";
    public static final String PREFER_VCARD_OVER_BUSINESS = "preferVCardOverBusiness";

    public static final String DEFAULT_TEXT = "text";
    public static final String DEFAULT_TITLE = "title";
    public static final String DEFAULT_TITLE_2 = "title2";
    public static final String DEFAULT_HREF = "http://ya.ru";
    public static final String DEFAULT_DOMAIN = "ya.ru";
    public static final String DEFAULT_DISPLAY_URL_PATH = "defaultpath";

    public static final int MAX_HREF_LENGTH = 1024;
    public static final int MIN_DOMAIN_LENGTH = 1;
    public static final int MAX_DOMAIN_LENGTH = 63;
    public static final int MIN_DISPLAY_URL_PATH = 1;
    public static final int MAX_DISPLAY_URL_PATH = 20;
    public static final int MIN_TOP_DOMAIN_LENGTH = 2;
    public static final int MAX_TOP_DOMAIN_LENGTH = 15;
    public static final int MAX_TITLE_LENGTH = 35;
    public static final int MAX_TITLE_2_LENGTH = 30;
    public static final int MAX_TEXT_LENGTH = 81;
    public static final int MAX_WORD_IN_TITLE_LENGTH = 22;
    public static final int MAX_WORD_IN_TEXT_LENGTH = 23;

    public static final int MAX_AD_EXTENSION_IDS_IN_AD = 50;


    public TextAdAddMap() {
        super();
        setBean(new TextAdAdd());
    }

    public TextAdAddMap(TextAdAdd textAdAdd) {
        super();
        setBean(textAdAdd);
    }

    public TextAdAddMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public TextAdAddMap withText(String text) {
        this.put(TEXT, text);
        return this;
    }

    public TextAdAddMap withTitle(String title) {
        this.put(TITLE, title);
        return this;
    }

    public TextAdAddMap withTitle2(String title2) {
        this.put(TITLE_2, title2);
        return this;
    }

    public TextAdAddMap withDisplayUrlPath(String displayUrlPath) {
        this.put(DISPLAY_URL_PATH, displayUrlPath);
        return this;
    }

    public TextAdAddMap withVideoExtension(VideoExtensionAddItemMap videoExtensionMap) {
        VideoExtensionAddItem videoExtension =
                ((videoExtensionMap == null) ? null : (VideoExtensionAddItem) (videoExtensionMap.getBean()));
        this.put(VIDEO_EXTENSION, videoExtension);
        return this;
    }

    public TextAdAddMap withPriceExtension(PriceExtensionAddItemMap priceExtensionMap) {
        PriceExtensionAddItem priceExtension =
                (priceExtensionMap == null) ? null : (PriceExtensionAddItem) (priceExtensionMap.getBean());
        this.put(PRICE_EXTENSION, priceExtension);
        return this;
    }

    public TextAdAddMap withVideoExtension(Long creativeID) {
        VideoExtensionAddItem videoExtension =
                (VideoExtensionAddItem) (new VideoExtensionAddItemMap().withCreativeId(creativeID).getBean());
        this.put(VIDEO_EXTENSION, videoExtension);
        return this;
    }

    public TextAdAddMap withHref(String href) {
        this.put(HREF, href);
        return this;
    }

    public TextAdAddMap withMobile(YesNoEnum mobile) {
        this.put(MOBILE, mobile);
        return this;
    }

    public TextAdAddMap withTurboPageId(Long turbopageId) {
        this.put(TURBO_PAGE_ID, turbopageId);
        return this;
    }

    public TextAdAddMap withBusinessId(Long businessId) {
        this.put(BUSINESS_ID, businessId);
        return this;
    }

    public TextAdAddMap withPreferVCardOverBusiness(YesNoEnum preferVCardOverBusiness) {
        this.put(PREFER_VCARD_OVER_BUSINESS, preferVCardOverBusiness);
        return this;
    }

    public TextAdAddMap defaultTextAd() {
        this.put(TEXT, DEFAULT_TEXT);
        this.put(TITLE, DEFAULT_TITLE);
        this.put(HREF, DEFAULT_HREF);
        this.put(MOBILE, YesNoEnum.NO);
        return this;
    }

    public TextAdAddMap defaultMobileAd() {
        this.put(TEXT, DEFAULT_TEXT);
        this.put(TITLE, DEFAULT_TITLE);
        this.put(HREF, DEFAULT_HREF);
        this.put(MOBILE, YesNoEnum.YES);
        return this;
    }
}
