package ru.yandex.autotests.directapi.model.api5.ads;

import com.yandex.direct.api.v5.ads.TextAdBuilderAdAdd;

public class TextAdBuilderAdAddMap extends AdBuilderAdAddBaseMap<TextAdBuilderAdAddMap> {
    public static final String HREF = "href";
    public static final String DEFAULT_HREF = "http://ya.ru";

    public TextAdBuilderAdAddMap() {
        super();
        setBean(new TextAdBuilderAdAdd());
    }

    public TextAdBuilderAdAddMap(TextAdBuilderAdAdd textAdBuilderAdAdd) {
        super();
        setBean(textAdBuilderAdAdd);
    }

    public TextAdBuilderAdAddMap withHref(String href) {
        this.put(HREF, href);
        return this;
    }

    public TextAdBuilderAdAddMap defaultTextAdBuilderAd(AdBuilderAdAddItemMap creative) {
        this.put(CREATIVE, creative.getBean());
        this.put(HREF, DEFAULT_HREF);
        return this;
    }

    public TextAdBuilderAdAddMap defaultTextAdBuilderAd(Long creativeId) {
        this.put(CREATIVE, new AdBuilderAdAddItemMap().withCreativeId(creativeId).getBean());
        this.put(HREF, DEFAULT_HREF);
        return this;
    }
}
