package ru.yandex.autotests.directapi.model.api5.ads;

import javax.xml.bind.JAXBElement;

import com.yandex.direct.api.v5.ads.ObjectFactory;
import com.yandex.direct.api.v5.ads.TextAdBuilderAdGet;
import com.yandex.direct.api.v5.general.ExtensionModeration;

import ru.yandex.autotests.directapi.model.api5.general.ExtensionModerationMap;

public class TextAdBuilderAdGetMap extends AdBuilderAdGetBaseMap<TextAdBuilderAdGetMap> {
    public static final String HREF = "href";
    public static final String TURBO_PAGE_ID = "turboPageId";
    public static final String TURBO_PAGE_MODERATION = "turboPageModeration";

    public TextAdBuilderAdGetMap() {
        super();
        setBean(new TextAdBuilderAdGet());
    }

    public TextAdBuilderAdGetMap(TextAdBuilderAdGet textAdBuilderAdGet) {
        super();
        setBean(textAdBuilderAdGet);
    }

    public TextAdBuilderAdGetMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public TextAdBuilderAdGetMap withHref(String href) {
        this.put(HREF, new ObjectFactory().createTextAdBuilderAdGetHref(href));
        return this;
    }

    public TextAdBuilderAdGetMap withTurboPageId(Long turboPageId) {
        this.put(TURBO_PAGE_ID, new ObjectFactory().createTextAdBuilderAdGetTurboPageId(turboPageId));
        return this;
    }

    public TextAdBuilderAdGetMap withTurboPageModeration(ExtensionModerationMap turboPageModeration) {
        JAXBElement<ExtensionModeration> jaxbElement =
                new ObjectFactory().createTextAdBuilderAdGetTurboPageModeration(
                        (turboPageModeration == null) ? null
                                : (ExtensionModeration) turboPageModeration.getBean());
        this.put(TURBO_PAGE_MODERATION, jaxbElement);
        return this;
    }
}
