package ru.yandex.autotests.directapi.model.api5.ads;

import javax.xml.bind.JAXBElement;

import com.yandex.direct.api.v5.ads.ObjectFactory;
import com.yandex.direct.api.v5.ads.TextAdBuilderAdUpdate;

public class TextAdBuilderAdUpdateMap  extends AdBuilderAdUpdateBaseMap<TextAdBuilderAdUpdateMap> {
    public static final String HREF = "href";
    public static final String TURBO_PAGE_ID = "turboPageId";

    public TextAdBuilderAdUpdateMap() {
        super();
        setBean(new TextAdBuilderAdUpdate());
    }

    public TextAdBuilderAdUpdateMap(TextAdBuilderAdUpdate textAdBuilderAdUpdate) {
        super();
        setBean(textAdBuilderAdUpdate);
    }

    public TextAdBuilderAdUpdateMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public TextAdBuilderAdUpdateMap withHref(String href) {
        JAXBElement<String> jaxbElement = new ObjectFactory().createTextAdBuilderAdUpdateHref(href);
        this.put(HREF, jaxbElement);
        return this;
    }

    public TextAdBuilderAdUpdateMap withTurboPageId(Long turboPageId) {
        JAXBElement<Long> jaxbElement = new ObjectFactory().createTextAdBuilderAdUpdateTurboPageId(turboPageId);
        this.put(TURBO_PAGE_ID, jaxbElement);
        return this;
    }

}
