package ru.yandex.autotests.directapi.model.api5.ads;

import javax.xml.bind.JAXBElement;

import com.yandex.direct.api.v5.ads.ObjectFactory;
import com.yandex.direct.api.v5.general.ExtensionModeration;

import ru.yandex.autotests.direct.utils.converter.BeanMapToBeanConverter;
import ru.yandex.autotests.direct.utils.model.ModelBeanMap;
import ru.yandex.autotests.directapi.model.api5.general.ExtensionModerationMap;

import static ch.lambdaj.Lambda.convert;

/**
 * Created by pavryabov on 22.04.15.
 */
public class TextAdGetBaseMap<T> extends ModelBeanMap<TextAdGetBaseMap> {

    public static final String VCARD_ID = "VCardId";
    public static final String ADIMAGE_HASH = "adImageHash";
    public static final String SITELINK_SET_ID = "sitelinkSetId";
    public static final String VCARD_MODERATION = "VCardModeration";
    public static final String SITELINKS_MODERATION = "sitelinksModeration";
    public static final String ADIMAGE_MODERATION = "adImageModeration";
    public static final String AD_EXTENSIONS = "adExtensions";

    public TextAdGetBaseMap() {
        super();
    }

    public T withVCardId(Long vCardId) {
        JAXBElement<Long> jaxbElement =
                new ObjectFactory().createTextAdGetBaseVCardId(vCardId);
        this.put(VCARD_ID, jaxbElement);
        return (T) this;
    }

    public T withAdImageHash(String adImageHash) {
        JAXBElement<String> jaxbElement =
                new ObjectFactory().createTextAdGetBaseAdImageHash(adImageHash);
        this.put(ADIMAGE_HASH, jaxbElement);
        return (T) this;
    }

    public T withSitelinkSetId(Long sitelinkSetId) {
        JAXBElement<Long> jaxbElement =
                new ObjectFactory().createTextAdGetBaseSitelinkSetId(sitelinkSetId);
        this.put(SITELINK_SET_ID, jaxbElement);
        return (T) this;
    }

    public T withVCardModeration(ExtensionModerationMap vCardModeration) {
        JAXBElement<ExtensionModeration> jaxbElement =
                new ObjectFactory().createTextAdGetBaseVCardModeration(
                        (vCardModeration == null) ? null : (ExtensionModeration) vCardModeration.getBean());
        this.put(VCARD_MODERATION, jaxbElement);
        return (T) this;
    }

    public T withSitelinksModeration(ExtensionModerationMap sitelinksModeration) {
        JAXBElement<ExtensionModeration> jaxbElement =
                new ObjectFactory().createTextAdGetBaseSitelinksModeration(
                        (sitelinksModeration == null) ? null : (ExtensionModeration) sitelinksModeration.getBean());
        this.put(SITELINKS_MODERATION, jaxbElement);
        return (T) this;
    }

    public T withAdExtensions(AdExtensionAdGetItemMap... maps) {
        this.put(AD_EXTENSIONS, (maps == null) ? null : convert(maps, new BeanMapToBeanConverter()));
        return (T) this;
    }

    public T withAdImageModeration(ExtensionModerationMap adImageModeration) {
        JAXBElement<ExtensionModeration> jaxbElement =
                new ObjectFactory().createTextAdGetBaseAdImageModeration(
                        (adImageModeration == null) ? null : (ExtensionModeration) adImageModeration.getBean());
        this.put(ADIMAGE_MODERATION, jaxbElement);
        return (T) this;
    }
}
