package ru.yandex.autotests.directapi.model.api5.ads;

import javax.xml.bind.JAXBElement;

import com.yandex.direct.api.v5.ads.ObjectFactory;
import com.yandex.direct.api.v5.ads.PriceExtensionGetItem;
import com.yandex.direct.api.v5.ads.TextAdGet;
import com.yandex.direct.api.v5.ads.VideoExtensionGetItem;
import com.yandex.direct.api.v5.general.ExtensionModeration;
import com.yandex.direct.api.v5.general.YesNoEnum;

import ru.yandex.autotests.directapi.model.api5.general.ExtensionModerationMap;

/**
 * Created by pavryabov on 22.04.15.
 */
public class TextAdGetMap extends TextAdGetBaseMap<TextAdGetMap> {

    public static final String TEXT = "text";
    public static final String TITLE = "title";
    public static final String TITLE_2 = "title2";
    public static final String HREF = "href";
    public static final String DISPLAY_DOMAIN = "displayDomain";
    public static final String MOBILE = "mobile";
    public static final String DISPLAY_URL_PATH = "displayUrlPath";
    public static final String DISPLAY_URL_PATH_MODERATION = "displayUrlPathModeration";
    public static final String VIDEO_EXTENSIONS = "videoExtension";
    public static final String PRICE_EXTENSION = "priceExtension";
    public static final String TURBO_PAGE_ID = "turboPageId";
    public static final String TURBO_PAGE_MODERATION = "turboPageModeration";
    public static final String BUSINESS_ID = "businessId";
    public static final String PREFER_VCARD_OVER_BUSINESS = "preferVCardOverBusiness";

    public TextAdGetMap() {
        super();
        setBean(new TextAdGet());
    }

    public TextAdGetMap(TextAdGet textAdGet) {
        super();
        setBean(textAdGet);
    }

    public TextAdGetMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public TextAdGetMap withText(String text) {
        this.put(TEXT, text);
        return this;
    }

    public TextAdGetMap withTitle(String title) {
        this.put(TITLE, title);
        return this;
    }

    public TextAdGetMap withTitle2(String title2) {
        JAXBElement<String> jaxbElement =
                new ObjectFactory().createTextAdGetTitle2(title2);
        this.put(TITLE_2, jaxbElement);
        return this;
    }

    public TextAdGetMap withHref(String href) {
        JAXBElement<String> jaxbElement =
                new ObjectFactory().createTextAdGetHref(href);
        this.put(HREF, jaxbElement);
        return this;
    }

    public TextAdGetMap withDisplayDomain(String displayDomain) {
        JAXBElement<String> jaxbElement =
                new ObjectFactory().createTextAdGetDisplayDomain(displayDomain);
        this.put(DISPLAY_DOMAIN, jaxbElement);
        return this;
    }

    public TextAdGetMap withMobile(YesNoEnum mobile) {
        this.put(MOBILE, mobile);
        return this;
    }

    public TextAdGetMap withDisplayUrlPath(String displayUrlPath) {
        JAXBElement<String> jaxbElement =
                new ObjectFactory().createTextAdGetDisplayUrlPath(displayUrlPath);
        this.put(DISPLAY_URL_PATH, jaxbElement);
        return this;
    }

    public TextAdGetMap withDisplayUrlPathModeration(ExtensionModerationMap displayUrlPathModeration) {
        JAXBElement<ExtensionModeration> jaxbElement =
                new ObjectFactory().createTextAdGetDisplayUrlPathModeration(
                        (displayUrlPathModeration == null) ? null
                                : (ExtensionModeration) displayUrlPathModeration.getBean());
        this.put(DISPLAY_URL_PATH_MODERATION, jaxbElement);
        return this;
    }

    public TextAdGetMap withVideoExtension(VideoExtensionGetItemMap videoExtension) {
        JAXBElement<VideoExtensionGetItem> jaxbElement =
                new ObjectFactory().createTextAdGetVideoExtension(
                        (videoExtension == null) ? null : (VideoExtensionGetItem) videoExtension.getBean());
        this.put(VIDEO_EXTENSIONS, jaxbElement);
        return this;
    }

    public TextAdGetMap withPriceExtension(PriceExtensionGetItemMap priceExtensionMap) {
        JAXBElement<PriceExtensionGetItem> jaxbElement =
                new ObjectFactory().createTextAdGetPriceExtension(
                        (priceExtensionMap == null) ? null : (PriceExtensionGetItem) priceExtensionMap.getBean());
        this.put(PRICE_EXTENSION, jaxbElement);
        return this;
    }

    public TextAdGetMap withTurboPageId(Long turboPageId) {
        this.put(TURBO_PAGE_ID, new ObjectFactory().createTextAdGetTurboPageId(turboPageId));
        return this;
    }

    public TextAdGetMap withTurboPageModeration(ExtensionModerationMap turboPageModeration) {
        JAXBElement<ExtensionModeration> jaxbElement =
                new ObjectFactory().createTextAdGetTurboPageModeration(
                        (turboPageModeration == null) ? null
                                : (ExtensionModeration) turboPageModeration.getBean());
        this.put(TURBO_PAGE_MODERATION, jaxbElement);
        return this;
    }

    public TextAdGetMap withBusinessId(Long businessId) {
        this.put(BUSINESS_ID, new ObjectFactory().createTextAdGetBusinessId(businessId));
        return this;
    }

    public TextAdGetMap withPreferVCardOverBusiness(YesNoEnum preferVCardOverBusiness) {
        this.put(PREFER_VCARD_OVER_BUSINESS,
                new ObjectFactory().createTextAdGetPreferVCardOverBusiness(preferVCardOverBusiness));
        return this;
    }
}
