package ru.yandex.autotests.directapi.model.api5.ads;

import javax.xml.bind.JAXBElement;

import com.yandex.direct.api.v5.adextensiontypes.AdExtensionSetting;
import com.yandex.direct.api.v5.ads.ObjectFactory;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;
import ru.yandex.autotests.directapi.model.api5.adextensiontypes.AdExtensionSettingMap;

/**
 * Created by pavryabov on 23.03.15.
 */
public class TextAdUpdateBaseMap<T> extends ModelBeanMap<TextAdUpdateBaseMap> {

    public static final String VCARD_ID = "VCardId";
    public static final String ADIMAGE_HASH = "adImageHash";
    public static final String SITELINK_SET_ID = "sitelinkSetId";
    public static final String CALLOUT_SETTING = "calloutSetting";

    public TextAdUpdateBaseMap() {
        super();
    }

    public T withVCardId(Long vCardId) {
        JAXBElement<Long> jaxbElement = new ObjectFactory().createTextAdUpdateBaseVCardId(vCardId);
        this.put(VCARD_ID, jaxbElement);
        return (T) this;
    }

    public T withAdImageHash(String adImageHash) {
        JAXBElement<String> jaxbElement = new ObjectFactory().createTextAdUpdateBaseAdImageHash(adImageHash);
        this.put(ADIMAGE_HASH, jaxbElement);
        return (T) this;
    }

    public T withSitelinkSetId(Long sitelinkSetId) {
        JAXBElement<Long> jaxbElement = new ObjectFactory().createTextAdUpdateBaseSitelinkSetId(sitelinkSetId);
        this.put(SITELINK_SET_ID, jaxbElement);
        return (T) this;
    }

    public T withCalloutSetting(AdExtensionSettingMap map) {
        AdExtensionSetting adExtensionSetting = ((map == null) ? null : (AdExtensionSetting) (map.getBean()));
        JAXBElement<AdExtensionSetting> jaxbElement =
                new ObjectFactory().createTextAdUpdateBaseCalloutSetting(adExtensionSetting);
        this.put(CALLOUT_SETTING, jaxbElement);
        return (T) this;
    }
}
