package ru.yandex.autotests.directapi.model.api5.ads;

import javax.xml.bind.JAXBElement;

import com.yandex.direct.api.v5.ads.AgeLabelEnum;
import com.yandex.direct.api.v5.ads.ObjectFactory;
import com.yandex.direct.api.v5.ads.PriceExtensionUpdateItem;
import com.yandex.direct.api.v5.ads.TextAdAdd;
import com.yandex.direct.api.v5.ads.TextAdUpdate;
import com.yandex.direct.api.v5.ads.VideoExtensionUpdateItem;

/**
 * Created by pavryabov on 23.03.15.
 */
public class TextAdUpdateMap extends TextAdUpdateBaseMap<TextAdUpdateMap> {

    public static final String TEXT = "text";
    public static final String TITLE = "title";
    public static final String TITLE_2 = "title2";
    public static final String HREF = "href";
    public static final String DISPLAY_URL_PATH = "displayUrlPath";
    public static final String AGE_LABEL = "ageLabel";
    public static final String VIDEO_EXTENSION = "videoExtension";
    public static final String PRICE_EXTENSION = "priceExtension";
    public static final String TURBO_PAGE_ID = "turboPageId";

    public static final int MAX_TEXT_LENGTH = 81;
    public static final int MAX_TEXT_WORD_LENGTH = 23;

    public static final int MAX_TITLE_LENGTH = 35;
    public static final int MAX_TITLE_WORD_LENGTH = 22;

    public TextAdUpdateMap() {
        super();
        setBean(new TextAdUpdate());
    }

    public TextAdUpdateMap(TextAdUpdate textAdUpdate) {
        super();
        setBean(textAdUpdate);
    }

    public TextAdUpdateMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public TextAdUpdateMap withText(String text) {
        this.put(TEXT, text);
        return this;
    }

    public TextAdUpdateMap withTitle(String title) {
        this.put(TITLE, title);
        return this;
    }

    public TextAdUpdateMap withTitle2(String title2) {
        JAXBElement<String> jaxbElement =
                new ObjectFactory().createTextAdUpdateTitle2(title2);
        this.put(TITLE_2, jaxbElement);
        return this;
    }

    public TextAdUpdateMap withHref(String href) {
        JAXBElement<String> jaxbElement = new ObjectFactory().createTextAdUpdateHref(href);
        this.put(HREF, jaxbElement);
        return this;
    }

    public TextAdUpdateMap withDisplayUrlPath(String displayUrlPath) {
        JAXBElement<String> jaxbElement = new ObjectFactory().createTextAdGetDisplayUrlPath(displayUrlPath);
        this.put(DISPLAY_URL_PATH, jaxbElement);
        return this;
    }

    public TextAdUpdateMap withAgeLabel(AgeLabelEnum ageLabel) {
        this.put(AGE_LABEL, ageLabel);
        return this;
    }

    public TextAdUpdateMap withVideoExtension(VideoExtensionUpdateItemMap videoExtensionMap) {
        VideoExtensionUpdateItem videoExtension =
                ((videoExtensionMap == null) ? null : (VideoExtensionUpdateItem) (videoExtensionMap.getBean()));
        this.put(VIDEO_EXTENSION, videoExtension);
        return this;
    }

    public TextAdUpdateMap withVideoExtension(Long creativeID) {
        VideoExtensionUpdateItem videoExtension =
                (VideoExtensionUpdateItem) (new VideoExtensionUpdateItemMap().withCreativeId(creativeID).getBean());
        this.put(VIDEO_EXTENSION, videoExtension);
        return this;
    }

    public TextAdUpdateMap withPriceExtension(PriceExtensionUpdateItemMap priceExtensionMap) {
        PriceExtensionUpdateItem priceExtension =
                (priceExtensionMap == null) ? null : (PriceExtensionUpdateItem) priceExtensionMap.getBean();
        JAXBElement<PriceExtensionUpdateItem> jaxbElement = new ObjectFactory()
                .createTextAdUpdatePriceExtension(priceExtension);
        this.put(PRICE_EXTENSION, jaxbElement);
        return this;
    }

    public TextAdUpdateMap withTurbPageId(Long turboPageId) {
        JAXBElement<Long> jaxbElement = new ObjectFactory().createTextAdUpdateTurboPageId(turboPageId);
        this.put(TURBO_PAGE_ID, jaxbElement);
        return this;
    }

    public TextAdUpdateMap defaultAd() {
        TextAdAdd textAd = (TextAdAdd) new TextAdAddMap().defaultTextAd().getBean();
        return this.withText(textAd.getText())
                .withTitle(textAd.getTitle())
                .withHref(textAd.getHref());
    }
}
