package ru.yandex.autotests.directapi.model.api5.ads;

import com.yandex.direct.api.v5.ads.TextImageAdAdd;

/**
 * Created by gerdler on 05.07.16.
 */
public class TextImageAdAddMap extends ImageAdAddBaseMap<TextImageAdAddMap> {
    public static final String HREF = "href";
    public static final String DEFAULT_HREF = "http://ya.ru";
    public static final int MAX_HREF_LENGTH = 1024;

    public TextImageAdAddMap() {
        super();
        setBean(new TextImageAdAdd());
    }

    public TextImageAdAddMap(TextImageAdAdd textImageAdAdd) {
        super();
        setBean(textImageAdAdd);
    }

    public TextImageAdAddMap withHref(String href) {
        this.put(HREF, href);
        return this;
    }

    public TextImageAdAddMap defaultTextImageAd(String adImageHash) {
        this.put(ADIMAGE_HASH, adImageHash);
        this.put(HREF, DEFAULT_HREF);
        return this;
    }

}
