package ru.yandex.autotests.directapi.model.api5.ads;

import javax.xml.bind.JAXBElement;

import com.yandex.direct.api.v5.ads.ObjectFactory;
import com.yandex.direct.api.v5.ads.TextImageAdGet;
import com.yandex.direct.api.v5.general.ExtensionModeration;

import ru.yandex.autotests.directapi.model.api5.general.ExtensionModerationMap;

/**
 * Created by gerdler on 08.07.16.
 */
public class TextImageAdGetMap extends ImageAdGetBaseMap<TextImageAdGetMap> {
    public static final String HREF = "href";
    public static final String TURBO_PAGE_ID = "turboPageId";
    public static final String TURBO_PAGE_MODERATION = "turboPageModeration";

    public TextImageAdGetMap() {
        super();
        setBean(new TextImageAdGet());
    }

    public TextImageAdGetMap(TextImageAdGet textImageAdGet) {
        super();
        setBean(textImageAdGet);
    }

    public TextImageAdGetMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public TextImageAdGetMap withHref(String href) {
        this.put(HREF, new ObjectFactory().createTextImageAdGetHref(href));
        return this;
    }

    public TextImageAdGetMap withTurboPageId(Long turboPageId) {
        this.put(TURBO_PAGE_ID, new ObjectFactory().createTextImageAdGetTurboPageId(turboPageId));
        return this;
    }

    public TextImageAdGetMap withTurboPageModeration(ExtensionModerationMap turboPageModeration) {
        JAXBElement<ExtensionModeration> jaxbElement =
                new ObjectFactory().createTextImageAdGetTurboPageModeration(
                        (turboPageModeration == null) ? null
                                : (ExtensionModeration) turboPageModeration.getBean());
        this.put(TURBO_PAGE_MODERATION, jaxbElement);
        return this;
    }

}
